/*
 * Decompiled with CFR 0.152.
 */
package com.stackify.log.log4j2;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.stackify.api.EnvironmentDetail;
import com.stackify.api.LogMsg;
import com.stackify.api.StackifyError;
import com.stackify.api.WebRequestDetail;
import com.stackify.api.common.lang.Throwables;
import com.stackify.api.common.log.APMLogData;
import com.stackify.api.common.log.EventAdapter;
import com.stackify.api.common.log.ServletLogContext;
import com.stackify.api.common.util.Maps;
import com.stackify.api.common.util.Preconditions;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.ThreadContext;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.message.Message;

public class LogEventAdapter
implements EventAdapter<LogEvent> {
    private final EnvironmentDetail envDetail;
    private final ObjectMapper json = new ObjectMapper();

    public LogEventAdapter(EnvironmentDetail envDetail) {
        Preconditions.checkNotNull((Object)envDetail);
        this.envDetail = envDetail;
    }

    public Throwable getThrowable(LogEvent event) {
        return event.getThrown();
    }

    public StackifyError getStackifyError(LogEvent event, Throwable exception) {
        WebRequestDetail webRequest;
        String user;
        StackifyError.Builder builder = StackifyError.newBuilder();
        builder.environmentDetail(this.envDetail);
        builder.occurredEpochMillis(new Date(event.getTimeMillis()));
        if (exception != null) {
            builder.error(Throwables.toErrorItem((String)this.getMessage(event), (Throwable)exception));
        } else {
            String className = null;
            String methodName = null;
            int lineNumber = 0;
            StackTraceElement source = event.getSource();
            if (source != null) {
                className = source.getClassName();
                methodName = source.getMethodName();
                try {
                    lineNumber = source.getLineNumber();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            builder.error(Throwables.toErrorItem((String)this.getMessage(event), (String)className, (String)methodName, (int)lineNumber));
        }
        String string = user = APMLogData.isLinked() ? APMLogData.getUser() : ServletLogContext.getUser();
        if (user != null) {
            builder.userName(user);
        }
        WebRequestDetail webRequestDetail = webRequest = APMLogData.isLinked() ? APMLogData.getWebRequest() : ServletLogContext.getWebRequest();
        if (webRequest != null) {
            builder.webRequestDetail(webRequest);
        }
        builder.serverVariables(Maps.fromProperties((Properties)System.getProperties()));
        return builder.build();
    }

    public LogMsg getLogMsg(LogEvent event, StackifyError error) {
        StackTraceElement source;
        String transactionId;
        LogMsg.Builder builder = LogMsg.newBuilder();
        builder.msg(this.getMessage(event));
        Map<String, String> props = this.getProperties(event);
        if (!props.isEmpty()) {
            try {
                builder.data(this.json.writeValueAsString(props));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        builder.ex(error);
        builder.th(event.getThreadName());
        builder.epochMs(Long.valueOf(event.getTimeMillis()));
        builder.level(event.getLevel().toString().toLowerCase());
        String string = transactionId = APMLogData.isLinked() ? APMLogData.getTransactionId() : ServletLogContext.getTransactionId();
        if (transactionId != null) {
            builder.transId(transactionId);
        }
        if ((source = event.getSource()) != null) {
            builder.srcMethod(source.getClassName() + "." + source.getMethodName());
            try {
                builder.srcLine(Integer.valueOf(source.getLineNumber()));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return builder.build();
    }

    public String getMessage(LogEvent event) {
        Message message = event.getMessage();
        if (message != null) {
            return message.getFormattedMessage();
        }
        return null;
    }

    public Map<String, String> getProperties(LogEvent event) {
        String ndc;
        ThreadContext.ContextStack contextStack;
        HashMap<String, String> properties = new HashMap<String, String>();
        Map mdc = event.getContextMap();
        if (mdc != null) {
            for (Map.Entry entryPair : mdc.entrySet()) {
                String key = (String)entryPair.getKey();
                String value = (String)entryPair.getValue();
                properties.put(key, value != null ? value.toString() : null);
            }
        }
        if ((contextStack = event.getContextStack()) != null && (ndc = contextStack.peek()) != null && !ndc.isEmpty()) {
            properties.put("NDC", ndc);
        }
        return properties;
    }

    public boolean isErrorLevel(LogEvent event) {
        return event.getLevel().isMoreSpecificThan(Level.ERROR);
    }

    public String getClassName(LogEvent event) {
        StackTraceElement source = event.getSource();
        if (source != null) {
            return source.getClassName();
        }
        return null;
    }
}

