/*
 * Decompiled with CFR 0.152.
 */
package com.stackify.log.log4j2;

import com.stackify.api.common.ApiClients;
import com.stackify.api.common.ApiConfiguration;
import com.stackify.api.common.ApiConfigurations;
import com.stackify.api.common.log.EventAdapter;
import com.stackify.api.common.log.LogAppender;
import com.stackify.api.common.mask.Masker;
import com.stackify.log.log4j2.LogEventAdapter;
import com.stackify.log.log4j2.Mask;
import com.stackify.log.log4j2.NonReentrantAppender;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginElement;
import org.apache.logging.log4j.core.config.plugins.PluginFactory;

@Plugin(name="StackifyLog", category="Core", elementType="appender")
public class StackifyLogAppender
extends NonReentrantAppender {
    private static final long serialVersionUID = -6565668877549998441L;
    private static final String DEFAULT_API_URL = "https://api.stackify.com";
    private final String apiUrl;
    private final String apiKey;
    private final String application;
    private final String environment;
    private final boolean skipJson;
    private final boolean maskEnabled;
    private final Mask[] masks;
    private LogAppender<LogEvent> logAppender;

    @PluginFactory
    public static StackifyLogAppender createAppender(@PluginAttribute(value="name") String name, @PluginElement(value="filters") Filter filter, @PluginAttribute(value="apiUrl") String apiUrl, @PluginAttribute(value="apiKey") String apiKey, @PluginAttribute(value="application") String application, @PluginAttribute(value="environment") String environment, @PluginAttribute(value="skipJson") String skipJson, @PluginAttribute(value="maskEnabled") String maskEnabled, @PluginElement(value="mask") Mask[] masks) {
        return new StackifyLogAppender(name, filter, apiUrl, apiKey, application, environment, Boolean.parseBoolean(skipJson), Boolean.parseBoolean(maskEnabled), masks);
    }

    protected StackifyLogAppender(String name, Filter filter, String apiUrl, String apiKey, String application, String environment, boolean skipJson, boolean maskEnabled, Mask[] masks) {
        super(name, filter, null);
        this.apiUrl = apiUrl != null ? apiUrl : DEFAULT_API_URL;
        this.apiKey = apiKey;
        this.application = application;
        this.environment = environment;
        this.skipJson = skipJson;
        this.maskEnabled = maskEnabled;
        this.masks = masks;
    }

    public void start() {
        super.start();
        if (this.logAppender == null) {
            ApiConfiguration apiConfig = ApiConfigurations.fromPropertiesWithOverrides((String)this.apiUrl, (String)this.apiKey, (String)this.application, (String)this.environment);
            String clientName = ApiClients.getApiClient(StackifyLogAppender.class, (String)"/stackify-log-log4j2.properties", (String)"stackify-log-log4j2");
            Masker masker = new Masker();
            if (this.maskEnabled) {
                masker.addMask("CREDITCARD");
                masker.addMask("SSN");
                if (this.masks != null && this.masks.length > 0) {
                    for (Mask mask : this.masks) {
                        if (mask.isEnabled()) {
                            masker.addMask(mask.getValue());
                            continue;
                        }
                        masker.removeMask(mask.getValue());
                    }
                }
            }
            try {
                this.logAppender = new LogAppender(clientName, (EventAdapter)new LogEventAdapter(apiConfig.getEnvDetail()), masker, this.skipJson);
                this.logAppender.activate(apiConfig);
            }
            catch (Exception e) {
                this.error("Exception starting the Stackify_LogBackgroundService", e);
            }
        }
    }

    @Override
    protected void subAppend(LogEvent event) {
        try {
            this.logAppender.append((Object)event);
        }
        catch (Exception e) {
            this.error("Exception appending event to Stackify Log Appender", event, e);
        }
    }

    public void stop() {
        super.stop();
        try {
            this.logAppender.close();
        }
        catch (Exception e) {
            this.error("Exception closing Stackify Log Appender", e);
        }
    }

    public String getApiUrl() {
        return this.apiUrl;
    }

    public String getApiKey() {
        return this.apiKey;
    }

    public String getApplication() {
        return this.application;
    }

    public String getEnvironment() {
        return this.environment;
    }

    public boolean isSkipJson() {
        return this.skipJson;
    }

    public boolean isMaskEnabled() {
        return this.maskEnabled;
    }

    public Mask[] getMasks() {
        return this.masks;
    }
}

