/*
 * Decompiled with CFR 0.152.
 */
package com.stackify.metric;

import com.stackify.metric.Counter;
import com.stackify.metric.Timer;
import java.util.Date;

public class CounterAndTimer {
    private final Counter counter;
    private final Timer timer;

    public CounterAndTimer(String category, String name) {
        this.counter = new Counter(category, name);
        this.timer = new Timer(category, name + " Time");
    }

    public Counter getCounter() {
        return this.counter;
    }

    public Timer getTimer() {
        return this.timer;
    }

    public void start(Date start) {
        if (start != null) {
            this.counter.increment();
            this.timer.start(start);
        }
    }

    public void startMs(long start) {
        this.counter.increment();
        this.timer.startMs(start);
    }

    public void durationMs(long duration) {
        this.counter.increment();
        this.timer.durationMs(duration);
    }

    public CounterAndTimer autoReportZeroValue() {
        this.counter.autoReportZeroValue();
        this.timer.autoReportZeroValue();
        return this;
    }
}

