/*
 * Decompiled with CFR 0.152.
 */
package com.stackify.metric;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.stackify.api.common.ApiConfiguration;
import com.stackify.api.common.ApiConfigurations;
import com.stackify.api.common.AppIdentityService;
import com.stackify.metric.impl.MetricBackgroundService;
import com.stackify.metric.impl.MetricCollector;
import com.stackify.metric.impl.MetricMonitorService;
import com.stackify.metric.impl.MetricSender;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetricManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(MetricManager.class);
    private static AtomicBoolean INITIALIZED = new AtomicBoolean(false);
    private static ApiConfiguration CONFIG = null;
    private static MetricCollector COLLECTOR = new MetricCollector();
    private static MetricBackgroundService BACKGROUND_SERVICE = null;

    public static MetricCollector getCollector() {
        if (INITIALIZED.compareAndSet(false, true)) {
            MetricManager.startup();
        }
        return COLLECTOR;
    }

    private static synchronized void startup() {
        try {
            CONFIG = ApiConfigurations.fromProperties();
            ObjectMapper objectMapper = new ObjectMapper();
            AppIdentityService appIdentityService = new AppIdentityService(CONFIG, objectMapper);
            MetricMonitorService monitorService = new MetricMonitorService(CONFIG, objectMapper, appIdentityService);
            MetricSender sender = new MetricSender(CONFIG, objectMapper, monitorService);
            BACKGROUND_SERVICE = new MetricBackgroundService(COLLECTOR, sender);
            BACKGROUND_SERVICE.start();
        }
        catch (Throwable t) {
            LOGGER.error("Exception starting Stackify Metrics API service", t);
        }
    }

    public static synchronized void shutdown() {
        if (BACKGROUND_SERVICE != null) {
            try {
                BACKGROUND_SERVICE.stop();
            }
            catch (Throwable t) {
                LOGGER.error("Exception stopping Stackify Metrics API service", t);
            }
        }
    }

    private MetricManager() {
    }
}

