/*
 * Decompiled with CFR 0.152.
 */
package com.stackify.metric.impl;

import com.stackify.metric.MetricManager;
import com.stackify.metric.impl.Metric;
import com.stackify.metric.impl.MetricCollector;
import com.stackify.metric.impl.MetricIdentity;
import com.stackify.metric.impl.MetricMonitorType;

public abstract class AbstractMetric {
    private final MetricIdentity identity;

    public AbstractMetric(String category, String name, MetricMonitorType type) {
        this.identity = new MetricIdentity(category, name, type);
    }

    public MetricIdentity getIdentity() {
        return this.identity;
    }

    protected void submit(double value, boolean isIncrement) {
        MetricCollector collector = MetricManager.getCollector();
        if (collector != null) {
            Metric.Builder builder = Metric.newBuilder();
            builder.identity(this.identity);
            builder.value(value);
            builder.isIncrement(isIncrement);
            Metric metric = builder.build();
            collector.submit(metric);
        }
    }

    protected void autoReportZero() {
        MetricCollector collector = MetricManager.getCollector();
        if (collector != null) {
            collector.autoReportZero(this.identity);
        }
    }

    protected void autoReportLast() {
        MetricCollector collector = MetricManager.getCollector();
        if (collector != null) {
            collector.autoReportLast(this.identity);
        }
    }
}

