/*
 * Decompiled with CFR 0.152.
 */
package com.stackify.metric.impl;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Date;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonDeserialize(builder=Builder.class)
public class JsonMetric {
    @JsonProperty(value="MonitorID")
    private final Integer monitorId;
    @JsonProperty(value="Value")
    private final Double value;
    @JsonProperty(value="Count")
    private final Integer count;
    @JsonProperty(value="OccurredUtc")
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyy-MM-dd'T'HH:mm:ss'Z'", timezone="UTC")
    private final Date occurredUtc;
    @JsonProperty(value="MonitorTypeID")
    private final Integer monitorTypeId;

    public Integer getMonitorId() {
        return this.monitorId;
    }

    public Double getValue() {
        return this.value;
    }

    public Integer getCount() {
        return this.count;
    }

    public Date getOccurredUtc() {
        return this.occurredUtc;
    }

    public Integer getMonitorTypeId() {
        return this.monitorTypeId;
    }

    private JsonMetric(Builder builder) {
        this.monitorId = builder.monitorId;
        this.value = builder.value;
        this.count = builder.count;
        this.occurredUtc = builder.occurredUtc;
        this.monitorTypeId = builder.monitorTypeId;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class Builder {
        @JsonProperty(value="MonitorID")
        private Integer monitorId;
        @JsonProperty(value="Value")
        private Double value;
        @JsonProperty(value="Count")
        private Integer count;
        @JsonProperty(value="OccurredUtc")
        @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyy-MM-dd'T'HH:mm:ss'Z'", timezone="UTC")
        private Date occurredUtc;
        @JsonProperty(value="MonitorTypeID")
        private Integer monitorTypeId;

        public Builder monitorId(Integer monitorId) {
            this.monitorId = monitorId;
            return this;
        }

        public Builder value(Double value) {
            this.value = value;
            return this;
        }

        public Builder count(Integer count) {
            this.count = count;
            return this;
        }

        public Builder occurredUtc(Date occurredUtc) {
            this.occurredUtc = occurredUtc;
            return this;
        }

        public Builder monitorTypeId(Integer monitorTypeId) {
            this.monitorTypeId = monitorTypeId;
            return this;
        }

        public JsonMetric build() {
            return new JsonMetric(this);
        }
    }
}

