/*
 * Decompiled with CFR 0.152.
 */
package com.stackify.metric.impl;

import com.stackify.metric.impl.MetricIdentity;

public class Metric {
    private final MetricIdentity identity;
    private final long occurredMillis = System.currentTimeMillis();
    private final double value;
    private final boolean isIncrement;

    public MetricIdentity getIdentity() {
        return this.identity;
    }

    public long getOccurredMillis() {
        return this.occurredMillis;
    }

    public double getValue() {
        return this.value;
    }

    public boolean isIncrement() {
        return this.isIncrement;
    }

    private Metric(Builder builder) {
        this.identity = builder.identity;
        this.value = builder.value;
        this.isIncrement = builder.isIncrement;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public String toString() {
        return "Metric [identity=" + this.identity + ", occurredMillis=" + this.occurredMillis + ", value=" + this.value + ", isIncrement=" + this.isIncrement + "]";
    }

    public static class Builder {
        private MetricIdentity identity;
        private double value;
        private boolean isIncrement;

        public Builder identity(MetricIdentity identity) {
            this.identity = identity;
            return this;
        }

        public Builder value(double value) {
            this.value = value;
            return this;
        }

        public Builder isIncrement(boolean isIncrement) {
            this.isIncrement = isIncrement;
            return this;
        }

        public Metric build() {
            return new Metric(this);
        }
    }
}

