/*
 * Decompiled with CFR 0.152.
 */
package com.stackify.metric.impl;

import com.stackify.api.common.util.Preconditions;
import com.stackify.metric.impl.Metric;
import com.stackify.metric.impl.MetricAggregate;
import com.stackify.metric.impl.MetricIdentity;
import com.stackify.metric.impl.MetricMonitorType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetricAggregator {
    private static final Logger LOGGER = LoggerFactory.getLogger(MetricAggregator.class);
    private final Map<MetricIdentity, Map<Long, MetricAggregate>> aggregates = new HashMap<MetricIdentity, Map<Long, MetricAggregate>>();
    private final long currentMinute;
    private final Map<MetricIdentity, Double> lastValues;

    public MetricAggregator(long currentMinute, Map<MetricIdentity, Double> lastValues) {
        Preconditions.checkArgument((0L < currentMinute ? 1 : 0) != 0);
        Preconditions.checkNotNull(lastValues);
        this.currentMinute = currentMinute;
        this.lastValues = lastValues;
    }

    public List<MetricAggregate> getAggregates() {
        ArrayList<MetricAggregate> flatAggregates = new ArrayList<MetricAggregate>();
        for (Map<Long, MetricAggregate> metricAggregates : this.aggregates.values()) {
            for (MetricAggregate aggregate : metricAggregates.values()) {
                flatAggregates.add(aggregate);
            }
        }
        return flatAggregates;
    }

    public void add(Metric metric) {
        Preconditions.checkNotNull((Object)metric);
        MetricAggregate aggregate = this.getAggregate(metric.getIdentity());
        switch (metric.getIdentity().getType()) {
            case COUNTER: 
            case TIMER: 
            case AVERAGE: {
                aggregate.setCount(aggregate.getCount() + 1);
                aggregate.setValue(aggregate.getValue() + metric.getValue());
                break;
            }
            case GAUGE: {
                aggregate.setCount(1);
                if (metric.isIncrement()) {
                    aggregate.setValue(aggregate.getValue() + metric.getValue());
                    break;
                }
                aggregate.setValue(metric.getValue());
                break;
            }
            default: {
                LOGGER.info("Unable to aggregate {} metric type", (Object)metric.getIdentity().getType());
            }
        }
    }

    public void autoReportZero(Set<MetricIdentity> autoMetrics) {
        Preconditions.checkNotNull(autoMetrics);
        for (MetricIdentity identity : autoMetrics) {
            if (this.aggregateExistsForCurrentMinute(identity)) continue;
            MetricAggregate aggregate = this.getAggregate(identity);
            aggregate.setCount(1);
            aggregate.setValue(0.0);
        }
    }

    public void autoReportLast(Set<MetricIdentity> autoMetrics) {
        Preconditions.checkNotNull(autoMetrics);
        for (MetricIdentity identity : autoMetrics) {
            if (this.aggregateExistsForCurrentMinute(identity)) continue;
            MetricAggregate aggregate = this.getAggregate(identity);
            aggregate.setCount(1);
            if (this.lastValues.containsKey(identity)) {
                aggregate.setValue(this.lastValues.get(identity));
                continue;
            }
            aggregate.setValue(0.0);
        }
    }

    private boolean aggregateExistsForCurrentMinute(MetricIdentity identity) {
        Preconditions.checkNotNull((Object)identity);
        return this.aggregates.containsKey(identity) && this.aggregates.get(identity).containsKey(this.currentMinute);
    }

    private MetricAggregate getAggregate(MetricIdentity identity) {
        Map<Long, MetricAggregate> metricAggregates;
        if (!this.aggregates.containsKey(identity)) {
            this.aggregates.put(identity, new HashMap());
        }
        if (!(metricAggregates = this.aggregates.get(identity)).containsKey(this.currentMinute)) {
            MetricAggregate initialAggregate = MetricAggregate.fromMetricIdentity(identity, this.currentMinute);
            if (identity.getType().equals((Object)MetricMonitorType.GAUGE) && this.lastValues.containsKey(identity)) {
                initialAggregate.setValue(this.lastValues.get(identity));
            }
            metricAggregates.put(this.currentMinute, initialAggregate);
        }
        MetricAggregate aggregate = metricAggregates.get(this.currentMinute);
        return aggregate;
    }
}

