/*
 * Decompiled with CFR 0.152.
 */
package com.stackify.metric.impl;

import com.stackify.api.common.concurrent.BackgroundService;
import com.stackify.api.common.util.Preconditions;
import com.stackify.metric.impl.MetricBackgroundServiceScheduler;
import com.stackify.metric.impl.MetricCollector;
import com.stackify.metric.impl.MetricSender;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetricBackgroundService
extends BackgroundService {
    private static final Logger LOGGER = LoggerFactory.getLogger(MetricBackgroundService.class);
    private final MetricBackgroundServiceScheduler scheduler = new MetricBackgroundServiceScheduler();
    private final MetricCollector collector;
    private final MetricSender sender;

    public MetricBackgroundService(MetricCollector collector, MetricSender sender) {
        Preconditions.checkNotNull((Object)collector);
        Preconditions.checkNotNull((Object)sender);
        this.collector = collector;
        this.sender = sender;
    }

    protected void startUp() {
    }

    protected void runOneIteration() {
        try {
            int numSent = this.collector.flush(this.sender);
            this.scheduler.update(numSent);
        }
        catch (Throwable t) {
            LOGGER.info("Exception flushing metrics collector", t);
            this.scheduler.update(t);
        }
    }

    protected long getNextScheduleDelayMilliseconds() {
        return this.scheduler.getScheduleDelay();
    }

    protected void shutDown() throws Exception {
        try {
            this.collector.flush(this.sender);
        }
        catch (Throwable t) {
            LOGGER.info("Exception flushing metrics collector during shut down", t);
        }
    }
}

