/*
 * Decompiled with CFR 0.152.
 */
package com.stackify.metric.impl;

import com.stackify.api.common.collect.SynchronizedEvictingQueue;
import com.stackify.api.common.http.HttpException;
import com.stackify.api.common.util.Preconditions;
import com.stackify.metric.impl.Metric;
import com.stackify.metric.impl.MetricAggregate;
import com.stackify.metric.impl.MetricAggregator;
import com.stackify.metric.impl.MetricIdentity;
import com.stackify.metric.impl.MetricMonitorType;
import com.stackify.metric.impl.MetricSender;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetricCollector {
    private static final Logger LOGGER = LoggerFactory.getLogger(MetricCollector.class);
    private static final int MS_IN_MIN = 60000;
    private final Queue<Metric> queue = new SynchronizedEvictingQueue(1000);
    private final Map<MetricIdentity, Double> lastValues = new HashMap<MetricIdentity, Double>();
    private final Set<MetricIdentity> autoReportZeroMetrics = new HashSet<MetricIdentity>();
    private final Set<MetricIdentity> autoReportLastMetrics = new HashSet<MetricIdentity>();
    private long lastFlush = 0L;

    public void autoReportZero(MetricIdentity identity) {
        Preconditions.checkNotNull((Object)identity);
        this.autoReportZeroMetrics.add(identity);
    }

    public void autoReportLast(MetricIdentity identity) {
        Preconditions.checkNotNull((Object)identity);
        this.autoReportLastMetrics.add(identity);
    }

    public void submit(Metric metric) {
        if (metric != null) {
            LOGGER.debug("Collecting metric: {}", (Object)metric);
            this.queue.offer(metric);
        }
    }

    public int flush(MetricSender sender) throws IOException, HttpException {
        Preconditions.checkNotNull((Object)sender);
        long currentMinute = System.currentTimeMillis() / 60000L * 60000L;
        LOGGER.debug("Flushing metrics < {}", (Object)currentMinute);
        MetricAggregator aggregator = new MetricAggregator(currentMinute, this.lastValues);
        while (!this.queue.isEmpty() && this.queue.peek().getOccurredMillis() < currentMinute) {
            aggregator.add(this.queue.remove());
        }
        if (this.lastFlush < currentMinute) {
            aggregator.autoReportZero(this.autoReportZeroMetrics);
            aggregator.autoReportLast(this.autoReportLastMetrics);
        }
        this.lastFlush = currentMinute;
        List<MetricAggregate> aggregates = aggregator.getAggregates();
        if (aggregates != null && !aggregates.isEmpty()) {
            for (MetricAggregate aggregate : aggregates) {
                if (aggregate.getIdentity().getType().equals((Object)MetricMonitorType.GAUGE)) {
                    this.lastValues.put(aggregate.getIdentity(), aggregate.getValue());
                    continue;
                }
                if (!aggregate.getIdentity().getType().equals((Object)MetricMonitorType.AVERAGE)) continue;
                this.lastValues.put(aggregate.getIdentity(), aggregate.getValue() / (double)aggregate.getCount());
            }
        }
        int numSent = 0;
        if (aggregates != null && !aggregates.isEmpty()) {
            LOGGER.debug("Sending aggregate metrics: {}", aggregates);
            sender.send(aggregates);
            numSent = aggregates.size();
        }
        return numSent;
    }
}

