/*
 * Decompiled with CFR 0.152.
 */
package com.stackify.metric.impl;

import com.stackify.api.common.util.Preconditions;
import com.stackify.metric.impl.MetricMonitorType;

public class MetricIdentity {
    private final String category;
    private final String name;
    private final MetricMonitorType type;

    public MetricIdentity(String category, String name, MetricMonitorType type) {
        Preconditions.checkNotNull((Object)category);
        Preconditions.checkArgument((!category.isEmpty() ? 1 : 0) != 0);
        Preconditions.checkNotNull((Object)name);
        Preconditions.checkArgument((!name.isEmpty() ? 1 : 0) != 0);
        Preconditions.checkNotNull((Object)((Object)type));
        this.category = category;
        this.name = name;
        this.type = type;
    }

    public String getCategory() {
        return this.category;
    }

    public String getName() {
        return this.name;
    }

    public MetricMonitorType getType() {
        return this.type;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.category == null ? 0 : this.category.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MetricIdentity)) {
            return false;
        }
        MetricIdentity other = (MetricIdentity)obj;
        if (this.category == null ? other.category != null : !this.category.equals(other.category)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        return this.type == other.type;
    }

    public String toString() {
        return "MetricIdentity [category=" + this.category + ", name=" + this.name + ", type=" + (Object)((Object)this.type) + "]";
    }
}

