/*
 * Decompiled with CFR 0.152.
 */
package com.stackify.metric.impl;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.stackify.api.AppIdentity;
import com.stackify.api.common.ApiConfiguration;
import com.stackify.api.common.AppIdentityService;
import com.stackify.api.common.http.HttpClient;
import com.stackify.api.common.http.HttpException;
import com.stackify.api.common.util.Preconditions;
import com.stackify.metric.impl.JsonGetMetricInfoRequest;
import com.stackify.metric.impl.JsonGetMetricInfoResponse;
import com.stackify.metric.impl.MetricIdentity;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetricMonitorService {
    private static final Logger LOGGER = LoggerFactory.getLogger(MetricMonitorService.class);
    private static long FIVE_MINUTES_MILLIS = 300000L;
    private final Map<MetricIdentity, Long> lastQueries = new HashMap<MetricIdentity, Long>();
    private Map<MetricIdentity, Integer> monitorIds = new HashMap<MetricIdentity, Integer>();
    private final ApiConfiguration apiConfig;
    private final ObjectMapper objectMapper;
    public final AppIdentityService appIdentityService;

    public MetricMonitorService(ApiConfiguration apiConfig, ObjectMapper objectMapper, AppIdentityService appIdentityService) {
        Preconditions.checkNotNull((Object)apiConfig);
        Preconditions.checkNotNull((Object)objectMapper);
        Preconditions.checkNotNull((Object)appIdentityService);
        this.apiConfig = apiConfig;
        this.objectMapper = objectMapper;
        this.appIdentityService = appIdentityService;
    }

    public Integer getMonitorId(MetricIdentity identity) throws IOException, HttpException {
        long currentTimeMillis;
        Preconditions.checkNotNull((Object)identity);
        if (this.monitorIds.containsKey(identity)) {
            return this.monitorIds.get(identity);
        }
        long lastQuery = 0L;
        if (this.lastQueries.containsKey(identity)) {
            lastQuery = this.lastQueries.get(identity);
        }
        if (lastQuery + FIVE_MINUTES_MILLIS < (currentTimeMillis = System.currentTimeMillis())) {
            try {
                this.lastQueries.put(identity, lastQuery);
                AppIdentity appIdentity = this.appIdentityService.getAppIdentity();
                if (appIdentity != null) {
                    int monitorId = this.getMetricInfo(identity, appIdentity);
                    LOGGER.debug("Metric {} monitor id: {}", (Object)identity, (Object)monitorId);
                    if (0 < monitorId) {
                        this.monitorIds.put(identity, monitorId);
                    }
                }
            }
            catch (Throwable t) {
                LOGGER.info("Unable to determine monitor id for metric {}", (Object)identity, (Object)t);
            }
        }
        if (this.monitorIds.containsKey(identity)) {
            return this.monitorIds.get(identity);
        }
        return null;
    }

    private int getMetricInfo(MetricIdentity identity, AppIdentity appIdentity) throws IOException, HttpException {
        Preconditions.checkNotNull((Object)identity);
        Preconditions.checkNotNull((Object)appIdentity);
        JsonGetMetricInfoRequest.Builder requestBuilder = JsonGetMetricInfoRequest.newBuilder();
        requestBuilder.category(identity.getCategory());
        requestBuilder.metricName(identity.getName());
        requestBuilder.deviceId(appIdentity.getDeviceId());
        requestBuilder.deviceAppId(appIdentity.getDeviceAppId());
        requestBuilder.appNameId(appIdentity.getAppNameId());
        requestBuilder.metricTypeId(identity.getType().getId());
        JsonGetMetricInfoRequest request = requestBuilder.build();
        byte[] jsonBytes = this.objectMapper.writer().writeValueAsBytes((Object)request);
        HttpClient httpClient = new HttpClient(this.apiConfig);
        String responseString = httpClient.post("/Metrics/GetMetricInfo", jsonBytes);
        ObjectReader jsonReader = this.objectMapper.reader((TypeReference)new TypeReference<JsonGetMetricInfoResponse>(){});
        JsonGetMetricInfoResponse response = (JsonGetMetricInfoResponse)jsonReader.readValue(responseString);
        if (response != null) {
            return response.getMonitorId();
        }
        return 0;
    }
}

