/*
 * Decompiled with CFR 0.152.
 */
package com.stackify.metric.impl;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.stackify.api.common.ApiConfiguration;
import com.stackify.api.common.http.HttpClient;
import com.stackify.api.common.http.HttpException;
import com.stackify.api.common.util.Preconditions;
import com.stackify.metric.impl.JsonMetric;
import com.stackify.metric.impl.MetricAggregate;
import com.stackify.metric.impl.MetricMonitorService;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetricSender {
    private static final Logger LOGGER = LoggerFactory.getLogger(MetricSender.class);
    private final ApiConfiguration apiConfig;
    private final ObjectMapper objectMapper;
    private final MetricMonitorService monitorService;

    public MetricSender(ApiConfiguration apiConfig, ObjectMapper objectMapper, MetricMonitorService monitorService) {
        Preconditions.checkNotNull((Object)apiConfig);
        Preconditions.checkNotNull((Object)objectMapper);
        Preconditions.checkNotNull((Object)monitorService);
        this.apiConfig = apiConfig;
        this.objectMapper = objectMapper;
        this.monitorService = monitorService;
    }

    public void send(List<MetricAggregate> aggregates) throws IOException, HttpException {
        ArrayList<JsonMetric> metrics = new ArrayList<JsonMetric>(aggregates.size());
        for (MetricAggregate aggregate : aggregates) {
            Integer monitorId = this.monitorService.getMonitorId(aggregate.getIdentity());
            if (monitorId != null) {
                JsonMetric.Builder builder = JsonMetric.newBuilder();
                builder.monitorId(monitorId);
                builder.value(aggregate.getValue());
                builder.count(aggregate.getCount());
                builder.occurredUtc(new Date(aggregate.getOccurredMillis()));
                builder.monitorTypeId(aggregate.getIdentity().getType().getId());
                metrics.add(builder.build());
                continue;
            }
            LOGGER.info("Unable to determine monitor id for aggregate metric {}", (Object)aggregate);
        }
        if (metrics.isEmpty()) {
            return;
        }
        byte[] jsonBytes = this.objectMapper.writer().writeValueAsBytes(metrics);
        HttpClient httpClient = new HttpClient(this.apiConfig);
        httpClient.post("/Metrics/SubmitMetricsByID", jsonBytes);
    }
}

