/**
 * Copyright 2011-2013 StackMob
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.stackmob.sdkapi;

import java.util.Map;

/**
 * An SMValue representing an object stored, or to be stored, in the StackMob Datastore
 */
public class SMObject extends SMValue<Map<String, SMValue>> {

  /**
   * Create a new SMObject
   * @param value the <code>Map</code> of object fields to their values
   */
  public SMObject(Map<String, SMValue> value) {
    super(value);
  }
}
