/*
 * Decompiled with CFR 0.152.
 */
package com.stackmob.sdk.api;

import com.stackmob.sdk.api.StackMob;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Base64;

public class StackMobSession {
    private static String SIGNATURE_ALGORITHM = "HmacSHA1";
    private String key;
    private String secret;
    private String userObjectName;
    private int apiVersionNumber;
    private String appName = null;
    private String lastUserLoginName;
    private long serverTimeDiff = 0L;
    private StackMob.OAuthVersion oauthVersion;
    private String oauth2Token;
    private String oauth2MacKey;
    private Date oauth2TokenExpiration;
    private boolean enableHTTPS = true;

    public StackMobSession(StackMob.OAuthVersion oauthVersion, String key, String secret, String userObjectName, String appName, int apiVersionNumber) {
        this(oauthVersion, key, secret, userObjectName, apiVersionNumber, null);
    }

    public StackMobSession(String key, String secret, String userObjectName, String appName, int apiVersionNumber) {
        this(key, secret, userObjectName, apiVersionNumber, null);
    }

    public StackMobSession(String key, String secret, String userObjectName, int apiVersionNumber, String appName) {
        this(StackMob.OAuthVersion.One, key, secret, userObjectName, apiVersionNumber, appName);
    }

    public StackMobSession(StackMob.OAuthVersion oauthVersion, String key, String secret, String userObjectName, int apiVersionNumber, String appName) {
        if (key.equals("DEFAULT_API_KEY") || oauthVersion != StackMob.OAuthVersion.Two && secret.equals("DEFAULT_API_SECRET")) {
            throw new RuntimeException("You forgot to set your api key and secret");
        }
        this.oauthVersion = oauthVersion;
        this.key = key;
        this.secret = secret;
        this.userObjectName = userObjectName;
        this.apiVersionNumber = apiVersionNumber;
        this.appName = appName;
    }

    public StackMobSession(StackMobSession that) {
        this.key = that.key;
        this.secret = that.secret;
        this.appName = that.appName;
        this.userObjectName = that.userObjectName;
        this.apiVersionNumber = that.apiVersionNumber;
    }

    public String getKey() {
        return this.key;
    }

    public String getSecret() {
        return this.secret;
    }

    public String getUserObjectName() {
        return this.userObjectName;
    }

    public int getApiVersionNumber() {
        return this.apiVersionNumber;
    }

    public String getAppName() {
        return this.appName;
    }

    protected long getLocalTime() {
        return new Date().getTime() / 1000L;
    }

    public long getServerTime() {
        if (this.getServerTimeDiff() != 0L) {
            StackMob.getLogger().logDebug("Adjusting time for server by %d seconds", this.getServerTimeDiff());
        }
        return this.getServerTimeDiff() + this.getLocalTime();
    }

    public void recordServerTimeDiff(String timeHeader) {
        StackMob.getLogger().logDebug("Got a time header of: %s", timeHeader);
        try {
            long serverTime = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz").parse(timeHeader).getTime() / 1000L;
            StackMob.getLogger().logDebug("Got a server time of %d versus local time %d", serverTime, this.getLocalTime());
            this.saveServerTimeDiff(serverTime - this.getLocalTime());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void saveServerTimeDiff(long serverTimeDiff) {
        this.serverTimeDiff = serverTimeDiff;
    }

    protected long getServerTimeDiff() {
        return this.serverTimeDiff;
    }

    protected void setLastUserLoginName(String username) {
        this.lastUserLoginName = username;
    }

    protected String getLastUserLoginName() {
        return this.lastUserLoginName;
    }

    public void setEnableHTTPS(boolean enableHTTPS) {
        this.enableHTTPS = enableHTTPS;
    }

    public boolean getEnableHTTPS() {
        return this.enableHTTPS;
    }

    public StackMob.OAuthVersion getOAuthVersion() {
        return this.oauthVersion;
    }

    public void setOAuthVersion(StackMob.OAuthVersion oauthVersion) {
        this.oauthVersion = oauthVersion;
    }

    public boolean isOAuth2() {
        return this.oauthVersion == StackMob.OAuthVersion.Two;
    }

    public void setOAuth2TokenAndExpiration(String accessToken, String macKey, int seconds) {
        this.oauth2Token = accessToken;
        this.oauth2MacKey = macKey;
        this.oauth2TokenExpiration = new Date(new Date().getTime() + (long)(seconds * 1000));
    }

    public Date getOAuth2TokenExpiration() {
        return this.oauth2TokenExpiration;
    }

    public boolean oauth2TokenValid() {
        return this.oauth2TokenExpiration != null && this.oauth2TokenExpiration.after(new Date());
    }

    public String generateMacToken(String method, String uri, String host, String port) {
        String ts = String.valueOf(new Date().getTime() / 1000L);
        String nonce = String.format("n%d", Math.round(Math.random() * 10000.0));
        try {
            String baseString = this.getNormalizedRequestString(ts, nonce, method, uri, host, port);
            Mac mac = Mac.getInstance(SIGNATURE_ALGORITHM);
            SecretKeySpec spec = new SecretKeySpec(this.oauth2MacKey.getBytes(), SIGNATURE_ALGORITHM);
            try {
                mac.init(spec);
            }
            catch (InvalidKeyException ike) {
                throw new IllegalStateException(ike);
            }
            byte[] rawMacBytes = mac.doFinal(baseString.getBytes());
            byte[] b64Bytes = Base64.encodeBase64((byte[])rawMacBytes);
            String calculatedMac = new String(b64Bytes);
            return String.format("MAC id=\"%s\",ts=\"%s\",nonce=\"%s\",mac=\"%s\"", this.oauth2Token, ts, nonce, calculatedMac);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException("This device doesn't have SHA1");
        }
    }

    private String getNormalizedRequestString(String timestamp, String nonce, String method, String uri, String host, String port) {
        return timestamp + "\n" + nonce + "\n" + method + "\n" + uri + "\n" + host + "\n" + port + "\n\n";
    }
}

