/*
 * Decompiled with CFR 0.152.
 */
package com.stackmob.sdk.model;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.stackmob.sdk.api.StackMob;
import com.stackmob.sdk.api.StackMobQuery;
import com.stackmob.sdk.callback.StackMobCallback;
import com.stackmob.sdk.callback.StackMobCountCallback;
import com.stackmob.sdk.callback.StackMobQueryCallback;
import com.stackmob.sdk.callback.StackMobRawCallback;
import com.stackmob.sdk.exception.StackMobException;
import com.stackmob.sdk.model.StackMobField;
import com.stackmob.sdk.model.StackMobModel;
import com.stackmob.sdk.util.GeoPoint;
import java.util.ArrayList;
import java.util.List;

public class StackMobModelQuery<T extends StackMobModel> {
    Class<T> classOfT;
    StackMobQuery query;

    public StackMobModelQuery(Class<T> classOfT) {
        this.classOfT = classOfT;
        this.query = new StackMobQuery(this.classOfT.getSimpleName().toLowerCase());
    }

    public StackMobQuery getQuery() {
        return this.query;
    }

    public void send(StackMobQueryCallback<T> callback) {
        final StackMobQueryCallback<T> furtherCallback = callback;
        StackMob.getStackMob().get(this.query, (StackMobRawCallback)new StackMobCallback(){

            @Override
            public void success(String responseBody) {
                JsonArray array = new JsonParser().parse(responseBody).getAsJsonArray();
                ArrayList<StackMobModel> resultList = new ArrayList<StackMobModel>();
                for (JsonElement elt : array) {
                    StackMobModel newObject = (StackMobModel)new Gson().fromJson("{}", StackMobModelQuery.this.classOfT);
                    newObject.setActualClass(StackMobModelQuery.this.classOfT);
                    try {
                        newObject.fillFromJson(elt);
                        resultList.add(newObject);
                    }
                    catch (StackMobException ignore) {}
                }
                furtherCallback.success(resultList);
            }

            @Override
            public void failure(StackMobException e) {
                furtherCallback.failure(e);
            }
        });
    }

    public void count(StackMobCountCallback callback) {
        StackMob.getStackMob().count(this.query, (StackMobRawCallback)callback);
    }

    public StackMobModelQuery<T> field(StackMobField fieldObj) {
        this.query.add(fieldObj.getQuery());
        return this;
    }

    public StackMobModelQuery<T> fieldIsNear(String field, GeoPoint point) {
        this.query.fieldIsNear(field, point);
        return this;
    }

    public StackMobModelQuery<T> fieldIsNearWithinMi(String field, GeoPoint point, Double maxDistanceMi) {
        this.query.fieldIsNearWithinMi(field, point, maxDistanceMi);
        return this;
    }

    public StackMobModelQuery<T> fieldIsNearWithinKm(String field, GeoPoint point, Double maxDistanceKm) {
        this.query.fieldIsNearWithinKm(field, point, maxDistanceKm);
        return this;
    }

    public StackMobModelQuery<T> fieldIsWithinRadiusInMi(String field, GeoPoint point, Double radiusInMi) {
        this.query.fieldIsWithinRadiusInMi(field, point, radiusInMi);
        return this;
    }

    public StackMobModelQuery<T> fieldIsWithinRadiusInKm(String field, GeoPoint point, Double radiusInKm) {
        this.query.fieldIsWithinRadiusInKm(field, point, radiusInKm);
        return this;
    }

    public StackMobModelQuery<T> fieldIsWithinBox(String field, GeoPoint lowerLeft, GeoPoint upperRight) {
        this.query.fieldIsWithinBox(field, lowerLeft, upperRight);
        return this;
    }

    public StackMobModelQuery<T> fieldIsIn(String field, List<String> values) {
        this.query.fieldIsIn(field, values);
        return this;
    }

    public StackMobModelQuery<T> fieldIsNotEqual(String field, String val) {
        this.query.fieldIsNotEqual(field, val);
        return this;
    }

    public StackMobModelQuery<T> fieldIsNull(String field) {
        this.query.fieldIsNull(field);
        return this;
    }

    public StackMobModelQuery<T> fieldIsNotNull(String field) {
        this.query.fieldIsNotNull(field);
        return this;
    }

    public StackMobModelQuery<T> fieldIsLessThan(String field, String val) {
        this.query.fieldIsLessThan(field, val);
        return this;
    }

    public StackMobModelQuery<T> fieldIsLessThanOrEqualTo(String field, String val) {
        this.query.fieldIslessThanOrEqualTo(field, val);
        return this;
    }

    public StackMobModelQuery<T> fieldIsGreaterThan(String field, String val) {
        this.query.fieldIsGreaterThan(field, val);
        return this;
    }

    public StackMobModelQuery<T> fieldIsGreaterThanOrEqualTo(String field, String val) {
        this.query.fieldIsGreaterThanOrEqualTo(field, val);
        return this;
    }

    public StackMobModelQuery<T> fieldIsEqualTo(String field, String val) {
        this.query.fieldIsEqualTo(field, val);
        return this;
    }

    public StackMobModelQuery<T> fieldIsOrderedBy(String field, StackMobQuery.Ordering ordering) {
        this.query.fieldIsOrderedBy(field, ordering);
        return this;
    }

    public StackMobModelQuery<T> expandDepthIs(Integer i) {
        this.query.expandDepthIs(i);
        return this;
    }

    public StackMobModelQuery<T> isInRange(Integer start, Integer end) {
        this.query.isInRange(start, end);
        return this;
    }

    public StackMobModelQuery<T> isInRange(Integer start) {
        this.query.isInRange(start);
        return this;
    }

    public StackMobModelQuery<T> select(List<String> fields) {
        this.query.select(fields);
        return this;
    }
}

