/*
 * Decompiled with CFR 0.152.
 */
package com.stackmob.sdk.push;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;

public class StackMobPushToken {
    private static TokenType defaultPushType = TokenType.Android;
    private String tokenString;
    private TokenType type;

    public static void setPushType(TokenType type) {
        defaultPushType = type;
    }

    public StackMobPushToken(String token) {
        this(token, defaultPushType);
    }

    public StackMobPushToken(String token, TokenType type) {
        this.tokenString = token;
        this.type = type;
    }

    public String getToken() {
        return this.tokenString;
    }

    public TokenType getTokenType() {
        return this.type;
    }

    public void setTokenType(TokenType type) {
        this.type = type;
    }

    public static class Deserializer
    implements JsonDeserializer<StackMobPushToken> {
        public StackMobPushToken deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) {
            JsonObject obj = json.getAsJsonObject();
            JsonPrimitive tokenStringPrimitive = obj.getAsJsonPrimitive("token");
            String tokenString = tokenStringPrimitive.getAsString();
            JsonPrimitive tokenTypePrimitive = obj.getAsJsonPrimitive("type");
            TokenType tokenType = TokenType.valueOf(tokenTypePrimitive.getAsString());
            return new StackMobPushToken(tokenString, tokenType);
        }
    }

    public static class Serializer
    implements JsonSerializer<StackMobPushToken> {
        public JsonElement serialize(StackMobPushToken token, Type typeOfSrc, JsonSerializationContext context) {
            JsonObject object = new JsonObject();
            object.add("type", (JsonElement)new JsonPrimitive(token.getTokenType().toString()));
            object.add("token", (JsonElement)new JsonPrimitive(token.getToken()));
            return object;
        }
    }

    public static enum TokenType {
        iOS("ios"),
        Android("androidGCM"),
        AndroidC2DM("android");

        private String type;

        private TokenType(String type) {
            this.type = type;
        }

        public String toString() {
            return this.type;
        }
    }
}

