/*
 * Decompiled with CFR 0.152.
 */
package com.stackmob.sdk.callback;

import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.stackmob.sdk.callback.StackMobRawCallback;
import com.stackmob.sdk.exception.StackMobException;
import com.stackmob.sdk.exception.StackMobHTTPResponseException;
import com.stackmob.sdk.net.HttpVerb;
import com.stackmob.sdk.util.Http;
import java.util.List;
import java.util.Map;

public abstract class StackMobCallback
extends StackMobRawCallback {
    @Override
    public void unsent(StackMobException e) {
        this.failure(e);
    }

    @Override
    public void temporaryPasswordResetRequired(StackMobException e) {
        this.failure(e);
    }

    @Override
    public void done(HttpVerb requestVerb, String requestURL, List<Map.Entry<String, String>> requestHeaders, String requestBody, Integer responseStatusCode, List<Map.Entry<String, String>> responseHeaders, byte[] responseBody) {
        if (Http.isSuccess(responseStatusCode)) {
            this.success(new String(responseBody));
        } else {
            StackMobHTTPResponseException smException = new StackMobHTTPResponseException(responseStatusCode, responseHeaders, responseBody);
            if (this.isTemporaryPasswordMessage("error") || this.isTemporaryPasswordMessage("error_description")) {
                this.temporaryPasswordResetRequired(smException);
            } else {
                this.failure(smException);
            }
        }
    }

    private boolean isTemporaryPasswordMessage(String name) {
        try {
            String test = new String(this.responseBody, "UTF-8");
            JsonElement message = new JsonParser().parse(new String(this.responseBody, "UTF-8")).getAsJsonObject().get(name);
            return message != null && message.isJsonPrimitive() && message.getAsJsonPrimitive().isString() && message.getAsString().startsWith("Temporary password reset required.");
        }
        catch (Exception e) {
            return false;
        }
    }

    public abstract void success(String var1);

    public abstract void failure(StackMobException var1);
}

