/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */


package com.stackone.stackone_client_java.models.components;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.stackone.stackone_client_java.utils.Utils;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Objects;
import org.openapitools.jackson.nullable.JsonNullable;
/**
 * PreferredLanguage - The employee preferred language
 */

public class PreferredLanguage {

    /**
     * The ISO639-2 Code of the language
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("value")
    private JsonNullable<? extends EmployeePreferredLanguageValue> value;

    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("source_value")
    private JsonNullable<? extends EmployeePreferredLanguageSourceValue> sourceValue;

    @JsonCreator
    public PreferredLanguage(
            @JsonProperty("value") JsonNullable<? extends EmployeePreferredLanguageValue> value,
            @JsonProperty("source_value") JsonNullable<? extends EmployeePreferredLanguageSourceValue> sourceValue) {
        Utils.checkNotNull(value, "value");
        Utils.checkNotNull(sourceValue, "sourceValue");
        this.value = value;
        this.sourceValue = sourceValue;
    }
    
    public PreferredLanguage() {
        this(JsonNullable.undefined(), JsonNullable.undefined());
    }

    /**
     * The ISO639-2 Code of the language
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<EmployeePreferredLanguageValue> value() {
        return (JsonNullable<EmployeePreferredLanguageValue>) value;
    }

    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<EmployeePreferredLanguageSourceValue> sourceValue() {
        return (JsonNullable<EmployeePreferredLanguageSourceValue>) sourceValue;
    }

    public final static Builder builder() {
        return new Builder();
    }

    /**
     * The ISO639-2 Code of the language
     */
    public PreferredLanguage withValue(EmployeePreferredLanguageValue value) {
        Utils.checkNotNull(value, "value");
        this.value = JsonNullable.of(value);
        return this;
    }

    /**
     * The ISO639-2 Code of the language
     */
    public PreferredLanguage withValue(JsonNullable<? extends EmployeePreferredLanguageValue> value) {
        Utils.checkNotNull(value, "value");
        this.value = value;
        return this;
    }

    public PreferredLanguage withSourceValue(EmployeePreferredLanguageSourceValue sourceValue) {
        Utils.checkNotNull(sourceValue, "sourceValue");
        this.sourceValue = JsonNullable.of(sourceValue);
        return this;
    }

    public PreferredLanguage withSourceValue(JsonNullable<? extends EmployeePreferredLanguageSourceValue> sourceValue) {
        Utils.checkNotNull(sourceValue, "sourceValue");
        this.sourceValue = sourceValue;
        return this;
    }
    
    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        PreferredLanguage other = (PreferredLanguage) o;
        return 
            Objects.deepEquals(this.value, other.value) &&
            Objects.deepEquals(this.sourceValue, other.sourceValue);
    }
    
    @Override
    public int hashCode() {
        return Objects.hash(
            value,
            sourceValue);
    }
    
    @Override
    public String toString() {
        return Utils.toString(PreferredLanguage.class,
                "value", value,
                "sourceValue", sourceValue);
    }
    
    public final static class Builder {
 
        private JsonNullable<? extends EmployeePreferredLanguageValue> value = JsonNullable.undefined();
 
        private JsonNullable<? extends EmployeePreferredLanguageSourceValue> sourceValue = JsonNullable.undefined();  
        
        private Builder() {
          // force use of static builder() method
        }

        /**
         * The ISO639-2 Code of the language
         */
        public Builder value(EmployeePreferredLanguageValue value) {
            Utils.checkNotNull(value, "value");
            this.value = JsonNullable.of(value);
            return this;
        }

        /**
         * The ISO639-2 Code of the language
         */
        public Builder value(JsonNullable<? extends EmployeePreferredLanguageValue> value) {
            Utils.checkNotNull(value, "value");
            this.value = value;
            return this;
        }

        public Builder sourceValue(EmployeePreferredLanguageSourceValue sourceValue) {
            Utils.checkNotNull(sourceValue, "sourceValue");
            this.sourceValue = JsonNullable.of(sourceValue);
            return this;
        }

        public Builder sourceValue(JsonNullable<? extends EmployeePreferredLanguageSourceValue> sourceValue) {
            Utils.checkNotNull(sourceValue, "sourceValue");
            this.sourceValue = sourceValue;
            return this;
        }
        
        public PreferredLanguage build() {
            return new PreferredLanguage(
                value,
                sourceValue);
        }
    }
}

