/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.operations;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.stackone.stackone_client_java.models.components.AtsUpdateJobRequestDto;
import com.stackone.stackone_client_java.utils.SpeakeasyMetadata;
import com.stackone.stackone_client_java.utils.Utils;
import java.util.Objects;

public class AtsUpdateJobRequest {
    @SpeakeasyMetadata(value="header:style=simple,explode=false,name=x-account-id")
    private String xAccountId;
    @SpeakeasyMetadata(value="pathParam:style=simple,explode=false,name=id")
    private String id;
    @SpeakeasyMetadata(value="request:mediaType=application/json")
    private AtsUpdateJobRequestDto atsUpdateJobRequestDto;

    @JsonCreator
    public AtsUpdateJobRequest(String xAccountId, String id, AtsUpdateJobRequestDto atsUpdateJobRequestDto) {
        Utils.checkNotNull(xAccountId, "xAccountId");
        Utils.checkNotNull(id, "id");
        Utils.checkNotNull(atsUpdateJobRequestDto, "atsUpdateJobRequestDto");
        this.xAccountId = xAccountId;
        this.id = id;
        this.atsUpdateJobRequestDto = atsUpdateJobRequestDto;
    }

    @JsonIgnore
    public String xAccountId() {
        return this.xAccountId;
    }

    @JsonIgnore
    public String id() {
        return this.id;
    }

    @JsonIgnore
    public AtsUpdateJobRequestDto atsUpdateJobRequestDto() {
        return this.atsUpdateJobRequestDto;
    }

    public static final Builder builder() {
        return new Builder();
    }

    public AtsUpdateJobRequest withXAccountId(String xAccountId) {
        Utils.checkNotNull(xAccountId, "xAccountId");
        this.xAccountId = xAccountId;
        return this;
    }

    public AtsUpdateJobRequest withId(String id) {
        Utils.checkNotNull(id, "id");
        this.id = id;
        return this;
    }

    public AtsUpdateJobRequest withAtsUpdateJobRequestDto(AtsUpdateJobRequestDto atsUpdateJobRequestDto) {
        Utils.checkNotNull(atsUpdateJobRequestDto, "atsUpdateJobRequestDto");
        this.atsUpdateJobRequestDto = atsUpdateJobRequestDto;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AtsUpdateJobRequest other = (AtsUpdateJobRequest)o;
        return Objects.deepEquals(this.xAccountId, other.xAccountId) && Objects.deepEquals(this.id, other.id) && Objects.deepEquals(this.atsUpdateJobRequestDto, other.atsUpdateJobRequestDto);
    }

    public int hashCode() {
        return Objects.hash(this.xAccountId, this.id, this.atsUpdateJobRequestDto);
    }

    public String toString() {
        return Utils.toString(AtsUpdateJobRequest.class, "xAccountId", this.xAccountId, "id", this.id, "atsUpdateJobRequestDto", this.atsUpdateJobRequestDto);
    }

    public static final class Builder {
        private String xAccountId;
        private String id;
        private AtsUpdateJobRequestDto atsUpdateJobRequestDto;

        private Builder() {
        }

        public Builder xAccountId(String xAccountId) {
            Utils.checkNotNull(xAccountId, "xAccountId");
            this.xAccountId = xAccountId;
            return this;
        }

        public Builder id(String id) {
            Utils.checkNotNull(id, "id");
            this.id = id;
            return this;
        }

        public Builder atsUpdateJobRequestDto(AtsUpdateJobRequestDto atsUpdateJobRequestDto) {
            Utils.checkNotNull(atsUpdateJobRequestDto, "atsUpdateJobRequestDto");
            this.atsUpdateJobRequestDto = atsUpdateJobRequestDto;
            return this;
        }

        public AtsUpdateJobRequest build() {
            return new AtsUpdateJobRequest(this.xAccountId, this.id, this.atsUpdateJobRequestDto);
        }
    }
}

