/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.operations;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.stackone.stackone_client_java.models.components.SkillsPaginated;
import com.stackone.stackone_client_java.utils.Response;
import com.stackone.stackone_client_java.utils.Utils;
import java.io.InputStream;
import java.net.http.HttpResponse;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Callable;

public class LmsListSkillsResponse
implements Response {
    private String contentType;
    private int statusCode;
    private HttpResponse<InputStream> rawResponse;
    private Optional<? extends SkillsPaginated> skillsPaginated;
    private Map<String, List<String>> headers;
    private Callable<Optional<LmsListSkillsResponse>> next = () -> Optional.empty();

    @JsonCreator
    public LmsListSkillsResponse(String contentType, int statusCode, HttpResponse<InputStream> rawResponse, Optional<? extends SkillsPaginated> skillsPaginated, Map<String, List<String>> headers) {
        Utils.checkNotNull(contentType, "contentType");
        Utils.checkNotNull(statusCode, "statusCode");
        Utils.checkNotNull(rawResponse, "rawResponse");
        Utils.checkNotNull(skillsPaginated, "skillsPaginated");
        headers = Utils.emptyMapIfNull(headers);
        this.contentType = contentType;
        this.statusCode = statusCode;
        this.rawResponse = rawResponse;
        this.skillsPaginated = skillsPaginated;
        this.headers = headers;
    }

    public LmsListSkillsResponse(String contentType, int statusCode, HttpResponse<InputStream> rawResponse, Map<String, List<String>> headers) {
        this(contentType, statusCode, rawResponse, Optional.empty(), headers);
    }

    @Override
    @JsonIgnore
    public String contentType() {
        return this.contentType;
    }

    @Override
    @JsonIgnore
    public int statusCode() {
        return this.statusCode;
    }

    @Override
    @JsonIgnore
    public HttpResponse<InputStream> rawResponse() {
        return this.rawResponse;
    }

    @JsonIgnore
    public Optional<SkillsPaginated> skillsPaginated() {
        return this.skillsPaginated;
    }

    @JsonIgnore
    public Map<String, List<String>> headers() {
        return this.headers;
    }

    public Optional<LmsListSkillsResponse> next() throws Exception {
        return this.next.call();
    }

    private LmsListSkillsResponse withNext(Callable<Optional<LmsListSkillsResponse>> next) {
        this.next = next;
        return this;
    }

    public static final Builder builder() {
        return new Builder();
    }

    public LmsListSkillsResponse withContentType(String contentType) {
        Utils.checkNotNull(contentType, "contentType");
        this.contentType = contentType;
        return this;
    }

    public LmsListSkillsResponse withStatusCode(int statusCode) {
        Utils.checkNotNull(statusCode, "statusCode");
        this.statusCode = statusCode;
        return this;
    }

    public LmsListSkillsResponse withRawResponse(HttpResponse<InputStream> rawResponse) {
        Utils.checkNotNull(rawResponse, "rawResponse");
        this.rawResponse = rawResponse;
        return this;
    }

    public LmsListSkillsResponse withSkillsPaginated(SkillsPaginated skillsPaginated) {
        Utils.checkNotNull(skillsPaginated, "skillsPaginated");
        this.skillsPaginated = Optional.ofNullable(skillsPaginated);
        return this;
    }

    public LmsListSkillsResponse withSkillsPaginated(Optional<? extends SkillsPaginated> skillsPaginated) {
        Utils.checkNotNull(skillsPaginated, "skillsPaginated");
        this.skillsPaginated = skillsPaginated;
        return this;
    }

    public LmsListSkillsResponse withHeaders(Map<String, List<String>> headers) {
        Utils.checkNotNull(headers, "headers");
        this.headers = headers;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LmsListSkillsResponse other = (LmsListSkillsResponse)o;
        return Objects.deepEquals(this.contentType, other.contentType) && Objects.deepEquals(this.statusCode, other.statusCode) && Objects.deepEquals(this.rawResponse, other.rawResponse) && Objects.deepEquals(this.skillsPaginated, other.skillsPaginated) && Objects.deepEquals(this.headers, other.headers);
    }

    public int hashCode() {
        return Objects.hash(this.contentType, this.statusCode, this.rawResponse, this.skillsPaginated, this.headers);
    }

    public String toString() {
        return Utils.toString(LmsListSkillsResponse.class, "contentType", this.contentType, "statusCode", this.statusCode, "rawResponse", this.rawResponse, "skillsPaginated", this.skillsPaginated, "headers", this.headers);
    }

    public static final class Builder {
        private Callable<Optional<LmsListSkillsResponse>> next;
        private String contentType;
        private Integer statusCode;
        private HttpResponse<InputStream> rawResponse;
        private Optional<? extends SkillsPaginated> skillsPaginated = Optional.empty();
        private Map<String, List<String>> headers;

        private Builder() {
        }

        public Builder contentType(String contentType) {
            Utils.checkNotNull(contentType, "contentType");
            this.contentType = contentType;
            return this;
        }

        public Builder statusCode(int statusCode) {
            Utils.checkNotNull(statusCode, "statusCode");
            this.statusCode = statusCode;
            return this;
        }

        public Builder rawResponse(HttpResponse<InputStream> rawResponse) {
            Utils.checkNotNull(rawResponse, "rawResponse");
            this.rawResponse = rawResponse;
            return this;
        }

        public Builder skillsPaginated(SkillsPaginated skillsPaginated) {
            Utils.checkNotNull(skillsPaginated, "skillsPaginated");
            this.skillsPaginated = Optional.ofNullable(skillsPaginated);
            return this;
        }

        public Builder skillsPaginated(Optional<? extends SkillsPaginated> skillsPaginated) {
            Utils.checkNotNull(skillsPaginated, "skillsPaginated");
            this.skillsPaginated = skillsPaginated;
            return this;
        }

        public Builder headers(Map<String, List<String>> headers) {
            Utils.checkNotNull(headers, "headers");
            this.headers = headers;
            return this;
        }

        @Deprecated
        public Builder next(Callable<Optional<LmsListSkillsResponse>> next) {
            Utils.checkNotNull(next, "next");
            this.next = next;
            return this;
        }

        public LmsListSkillsResponse build() {
            return new LmsListSkillsResponse(this.contentType, this.statusCode, this.rawResponse, this.skillsPaginated, this.headers).withNext(this.next);
        }
    }
}

