/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.core.JacksonException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonDeserialize(using=_Deserializer.class)
@JsonSerialize(using=_Serializer.class)
public class JobConfidential {
    public static final JobConfidential TRUE = new JobConfidential("true");
    public static final JobConfidential FALSE = new JobConfidential("false");
    private static final Map<String, JobConfidential> values = JobConfidential.createValuesMap();
    private static final Map<String, JobConfidentialEnum> enums = JobConfidential.createEnumsMap();
    private final String value;

    private JobConfidential(String value) {
        this.value = value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JobConfidential of(String value) {
        Class<JobConfidential> clazz = JobConfidential.class;
        synchronized (JobConfidential.class) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return values.computeIfAbsent(value, v -> new JobConfidential((String)v));
        }
    }

    public String value() {
        return this.value;
    }

    public Optional<JobConfidentialEnum> asEnum() {
        return Optional.ofNullable(enums.getOrDefault(this.value, null));
    }

    public boolean isKnown() {
        return this.asEnum().isPresent();
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        JobConfidential other = (JobConfidential)obj;
        return Objects.equals(this.value, other.value);
    }

    public String toString() {
        return "JobConfidential [value=" + this.value + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JobConfidential[] values() {
        Class<JobConfidential> clazz = JobConfidential.class;
        synchronized (JobConfidential.class) {
            // ** MonitorExit[var0] (shouldn't be in output)
            return values.values().toArray(new JobConfidential[0]);
        }
    }

    private static final Map<String, JobConfidential> createValuesMap() {
        LinkedHashMap<String, JobConfidential> map = new LinkedHashMap<String, JobConfidential>();
        map.put("true", TRUE);
        map.put("false", FALSE);
        return map;
    }

    private static final Map<String, JobConfidentialEnum> createEnumsMap() {
        HashMap<String, JobConfidentialEnum> map = new HashMap<String, JobConfidentialEnum>();
        map.put("true", JobConfidentialEnum.TRUE);
        map.put("false", JobConfidentialEnum.FALSE);
        return map;
    }

    public static enum JobConfidentialEnum {
        TRUE("true"),
        FALSE("false");

        private final String value;

        private JobConfidentialEnum(String value) {
            this.value = value;
        }

        public String value() {
            return this.value;
        }
    }

    public static final class _Deserializer
    extends StdDeserializer<JobConfidential> {
        protected _Deserializer() {
            super(JobConfidential.class);
        }

        public JobConfidential deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JacksonException {
            String v = (String)p.readValueAs((TypeReference)new TypeReference<String>(){});
            return JobConfidential.of(v);
        }
    }

    public static final class _Serializer
    extends StdSerializer<JobConfidential> {
        protected _Serializer() {
            super(JobConfidential.class);
        }

        public void serialize(JobConfidential value, JsonGenerator g, SerializerProvider provider) throws IOException, JsonProcessingException {
            g.writeObject((Object)value.value);
        }
    }
}

