/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.stackone.stackone_client_java.models.components.SkillsProficiencySourceValue;
import com.stackone.stackone_client_java.models.components.SkillsProficiencyValue;
import com.stackone.stackone_client_java.utils.Utils;
import java.util.Objects;
import org.openapitools.jackson.nullable.JsonNullable;

public class Proficiency {
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="value")
    private JsonNullable<? extends SkillsProficiencyValue> value;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="source_value")
    private JsonNullable<? extends SkillsProficiencySourceValue> sourceValue;

    @JsonCreator
    public Proficiency(@JsonProperty(value="value") JsonNullable<? extends SkillsProficiencyValue> value, @JsonProperty(value="source_value") JsonNullable<? extends SkillsProficiencySourceValue> sourceValue) {
        Utils.checkNotNull(value, "value");
        Utils.checkNotNull(sourceValue, "sourceValue");
        this.value = value;
        this.sourceValue = sourceValue;
    }

    public Proficiency() {
        this((JsonNullable<? extends SkillsProficiencyValue>)JsonNullable.undefined(), (JsonNullable<? extends SkillsProficiencySourceValue>)JsonNullable.undefined());
    }

    @JsonIgnore
    public JsonNullable<SkillsProficiencyValue> value() {
        return this.value;
    }

    @JsonIgnore
    public JsonNullable<SkillsProficiencySourceValue> sourceValue() {
        return this.sourceValue;
    }

    public static final Builder builder() {
        return new Builder();
    }

    public Proficiency withValue(SkillsProficiencyValue value) {
        Utils.checkNotNull(value, "value");
        this.value = JsonNullable.of((Object)value);
        return this;
    }

    public Proficiency withValue(JsonNullable<? extends SkillsProficiencyValue> value) {
        Utils.checkNotNull(value, "value");
        this.value = value;
        return this;
    }

    public Proficiency withSourceValue(SkillsProficiencySourceValue sourceValue) {
        Utils.checkNotNull(sourceValue, "sourceValue");
        this.sourceValue = JsonNullable.of((Object)sourceValue);
        return this;
    }

    public Proficiency withSourceValue(JsonNullable<? extends SkillsProficiencySourceValue> sourceValue) {
        Utils.checkNotNull(sourceValue, "sourceValue");
        this.sourceValue = sourceValue;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Proficiency other = (Proficiency)o;
        return Objects.deepEquals(this.value, other.value) && Objects.deepEquals(this.sourceValue, other.sourceValue);
    }

    public int hashCode() {
        return Objects.hash(this.value, this.sourceValue);
    }

    public String toString() {
        return Utils.toString(Proficiency.class, "value", this.value, "sourceValue", this.sourceValue);
    }

    public static final class Builder {
        private JsonNullable<? extends SkillsProficiencyValue> value = JsonNullable.undefined();
        private JsonNullable<? extends SkillsProficiencySourceValue> sourceValue = JsonNullable.undefined();

        private Builder() {
        }

        public Builder value(SkillsProficiencyValue value) {
            Utils.checkNotNull(value, "value");
            this.value = JsonNullable.of((Object)value);
            return this;
        }

        public Builder value(JsonNullable<? extends SkillsProficiencyValue> value) {
            Utils.checkNotNull(value, "value");
            this.value = value;
            return this;
        }

        public Builder sourceValue(SkillsProficiencySourceValue sourceValue) {
            Utils.checkNotNull(sourceValue, "sourceValue");
            this.sourceValue = JsonNullable.of((Object)sourceValue);
            return this;
        }

        public Builder sourceValue(JsonNullable<? extends SkillsProficiencySourceValue> sourceValue) {
            Utils.checkNotNull(sourceValue, "sourceValue");
            this.sourceValue = sourceValue;
            return this;
        }

        public Proficiency build() {
            return new Proficiency(this.value, this.sourceValue);
        }
    }
}

