/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java.models.operations;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.stackone.stackone_client_java.utils.SpeakeasyMetadata;
import com.stackone.stackone_client_java.utils.Utils;
import java.lang.Boolean;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.time.OffsetDateTime;
import org.openapitools.jackson.nullable.JsonNullable;

/**
 * StackoneListPlatformLogsQueryParamFilter
 * 
 * <p>Filter parameters that allow greater customisation of the list response
 */
public class StackoneListPlatformLogsQueryParamFilter {
    /**
     * A comma-separated list of account IDs to filter the results by.
     */
    @SpeakeasyMetadata("queryParam:name=account_ids")
    private JsonNullable<String> accountIds;

    /**
     * A ISO8601 date string to filter the results by start_date.
     */
    @SpeakeasyMetadata("queryParam:name=start_date")
    private JsonNullable<OffsetDateTime> startDate;

    /**
     * A ISO8601 date string to filter the results by end_date.
     */
    @SpeakeasyMetadata("queryParam:name=end_date")
    private JsonNullable<OffsetDateTime> endDate;

    /**
     * A comma-separated list of request IDs to filter the results by.
     */
    @SpeakeasyMetadata("queryParam:name=request_ids")
    private JsonNullable<String> requestIds;

    /**
     * A comma-separated list of source types to filter the results by.
     */
    @SpeakeasyMetadata("queryParam:name=source_types")
    private JsonNullable<String> sourceTypes;

    /**
     * A comma-separated list of source values to filter the results by.
     */
    @SpeakeasyMetadata("queryParam:name=source_values")
    private JsonNullable<String> sourceValues;

    /**
     * A comma-separated list of source IDs to filter the results by.
     */
    @SpeakeasyMetadata("queryParam:name=source_ids")
    private JsonNullable<String> sourceIds;

    /**
     * A comma-separated list of HTTP methods to filter the results by.
     */
    @SpeakeasyMetadata("queryParam:name=http_methods")
    private JsonNullable<String> httpMethods;

    /**
     * A comma-separated list of categories to filter the results by.
     */
    @SpeakeasyMetadata("queryParam:name=categories")
    private JsonNullable<String> categories;

    /**
     * A comma-separated list of resources to filter the results by.
     */
    @SpeakeasyMetadata("queryParam:name=resources")
    private JsonNullable<String> resources;

    /**
     * A comma-separated list of actions to filter the results by.
     */
    @SpeakeasyMetadata("queryParam:name=actions")
    private JsonNullable<String> actions;

    /**
     * A comma-separated list of status codes to filter the results by.
     */
    @SpeakeasyMetadata("queryParam:name=status_codes")
    private JsonNullable<String> statusCodes;

    /**
     * A boolean value to filter the results by success or failure.
     */
    @SpeakeasyMetadata("queryParam:name=success")
    private JsonNullable<Boolean> success;

    /**
     * The field to order the results by.
     */
    @SpeakeasyMetadata("queryParam:name=order_by")
    private JsonNullable<? extends StackoneListPlatformLogsQueryParamRequestLogsOrderBy> orderBy;

    /**
     * The direction to order the results by.
     */
    @SpeakeasyMetadata("queryParam:name=order_direction")
    private JsonNullable<? extends StackoneListPlatformLogsQueryParamRequestLogsOrderDirection> orderDirection;

    @JsonCreator
    public StackoneListPlatformLogsQueryParamFilter(
            JsonNullable<String> accountIds,
            JsonNullable<OffsetDateTime> startDate,
            JsonNullable<OffsetDateTime> endDate,
            JsonNullable<String> requestIds,
            JsonNullable<String> sourceTypes,
            JsonNullable<String> sourceValues,
            JsonNullable<String> sourceIds,
            JsonNullable<String> httpMethods,
            JsonNullable<String> categories,
            JsonNullable<String> resources,
            JsonNullable<String> actions,
            JsonNullable<String> statusCodes,
            JsonNullable<Boolean> success,
            JsonNullable<? extends StackoneListPlatformLogsQueryParamRequestLogsOrderBy> orderBy,
            JsonNullable<? extends StackoneListPlatformLogsQueryParamRequestLogsOrderDirection> orderDirection) {
        Utils.checkNotNull(accountIds, "accountIds");
        Utils.checkNotNull(startDate, "startDate");
        Utils.checkNotNull(endDate, "endDate");
        Utils.checkNotNull(requestIds, "requestIds");
        Utils.checkNotNull(sourceTypes, "sourceTypes");
        Utils.checkNotNull(sourceValues, "sourceValues");
        Utils.checkNotNull(sourceIds, "sourceIds");
        Utils.checkNotNull(httpMethods, "httpMethods");
        Utils.checkNotNull(categories, "categories");
        Utils.checkNotNull(resources, "resources");
        Utils.checkNotNull(actions, "actions");
        Utils.checkNotNull(statusCodes, "statusCodes");
        Utils.checkNotNull(success, "success");
        Utils.checkNotNull(orderBy, "orderBy");
        Utils.checkNotNull(orderDirection, "orderDirection");
        this.accountIds = accountIds;
        this.startDate = startDate;
        this.endDate = endDate;
        this.requestIds = requestIds;
        this.sourceTypes = sourceTypes;
        this.sourceValues = sourceValues;
        this.sourceIds = sourceIds;
        this.httpMethods = httpMethods;
        this.categories = categories;
        this.resources = resources;
        this.actions = actions;
        this.statusCodes = statusCodes;
        this.success = success;
        this.orderBy = orderBy;
        this.orderDirection = orderDirection;
    }
    
    public StackoneListPlatformLogsQueryParamFilter() {
        this(JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(),
            JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(),
            JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(),
            JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(),
            JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined());
    }

    /**
     * A comma-separated list of account IDs to filter the results by.
     */
    @JsonIgnore
    public JsonNullable<String> accountIds() {
        return accountIds;
    }

    /**
     * A ISO8601 date string to filter the results by start_date.
     */
    @JsonIgnore
    public JsonNullable<OffsetDateTime> startDate() {
        return startDate;
    }

    /**
     * A ISO8601 date string to filter the results by end_date.
     */
    @JsonIgnore
    public JsonNullable<OffsetDateTime> endDate() {
        return endDate;
    }

    /**
     * A comma-separated list of request IDs to filter the results by.
     */
    @JsonIgnore
    public JsonNullable<String> requestIds() {
        return requestIds;
    }

    /**
     * A comma-separated list of source types to filter the results by.
     */
    @JsonIgnore
    public JsonNullable<String> sourceTypes() {
        return sourceTypes;
    }

    /**
     * A comma-separated list of source values to filter the results by.
     */
    @JsonIgnore
    public JsonNullable<String> sourceValues() {
        return sourceValues;
    }

    /**
     * A comma-separated list of source IDs to filter the results by.
     */
    @JsonIgnore
    public JsonNullable<String> sourceIds() {
        return sourceIds;
    }

    /**
     * A comma-separated list of HTTP methods to filter the results by.
     */
    @JsonIgnore
    public JsonNullable<String> httpMethods() {
        return httpMethods;
    }

    /**
     * A comma-separated list of categories to filter the results by.
     */
    @JsonIgnore
    public JsonNullable<String> categories() {
        return categories;
    }

    /**
     * A comma-separated list of resources to filter the results by.
     */
    @JsonIgnore
    public JsonNullable<String> resources() {
        return resources;
    }

    /**
     * A comma-separated list of actions to filter the results by.
     */
    @JsonIgnore
    public JsonNullable<String> actions() {
        return actions;
    }

    /**
     * A comma-separated list of status codes to filter the results by.
     */
    @JsonIgnore
    public JsonNullable<String> statusCodes() {
        return statusCodes;
    }

    /**
     * A boolean value to filter the results by success or failure.
     */
    @JsonIgnore
    public JsonNullable<Boolean> success() {
        return success;
    }

    /**
     * The field to order the results by.
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<StackoneListPlatformLogsQueryParamRequestLogsOrderBy> orderBy() {
        return (JsonNullable<StackoneListPlatformLogsQueryParamRequestLogsOrderBy>) orderBy;
    }

    /**
     * The direction to order the results by.
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<StackoneListPlatformLogsQueryParamRequestLogsOrderDirection> orderDirection() {
        return (JsonNullable<StackoneListPlatformLogsQueryParamRequestLogsOrderDirection>) orderDirection;
    }

    public static Builder builder() {
        return new Builder();
    }


    /**
     * A comma-separated list of account IDs to filter the results by.
     */
    public StackoneListPlatformLogsQueryParamFilter withAccountIds(String accountIds) {
        Utils.checkNotNull(accountIds, "accountIds");
        this.accountIds = JsonNullable.of(accountIds);
        return this;
    }

    /**
     * A comma-separated list of account IDs to filter the results by.
     */
    public StackoneListPlatformLogsQueryParamFilter withAccountIds(JsonNullable<String> accountIds) {
        Utils.checkNotNull(accountIds, "accountIds");
        this.accountIds = accountIds;
        return this;
    }

    /**
     * A ISO8601 date string to filter the results by start_date.
     */
    public StackoneListPlatformLogsQueryParamFilter withStartDate(OffsetDateTime startDate) {
        Utils.checkNotNull(startDate, "startDate");
        this.startDate = JsonNullable.of(startDate);
        return this;
    }

    /**
     * A ISO8601 date string to filter the results by start_date.
     */
    public StackoneListPlatformLogsQueryParamFilter withStartDate(JsonNullable<OffsetDateTime> startDate) {
        Utils.checkNotNull(startDate, "startDate");
        this.startDate = startDate;
        return this;
    }

    /**
     * A ISO8601 date string to filter the results by end_date.
     */
    public StackoneListPlatformLogsQueryParamFilter withEndDate(OffsetDateTime endDate) {
        Utils.checkNotNull(endDate, "endDate");
        this.endDate = JsonNullable.of(endDate);
        return this;
    }

    /**
     * A ISO8601 date string to filter the results by end_date.
     */
    public StackoneListPlatformLogsQueryParamFilter withEndDate(JsonNullable<OffsetDateTime> endDate) {
        Utils.checkNotNull(endDate, "endDate");
        this.endDate = endDate;
        return this;
    }

    /**
     * A comma-separated list of request IDs to filter the results by.
     */
    public StackoneListPlatformLogsQueryParamFilter withRequestIds(String requestIds) {
        Utils.checkNotNull(requestIds, "requestIds");
        this.requestIds = JsonNullable.of(requestIds);
        return this;
    }

    /**
     * A comma-separated list of request IDs to filter the results by.
     */
    public StackoneListPlatformLogsQueryParamFilter withRequestIds(JsonNullable<String> requestIds) {
        Utils.checkNotNull(requestIds, "requestIds");
        this.requestIds = requestIds;
        return this;
    }

    /**
     * A comma-separated list of source types to filter the results by.
     */
    public StackoneListPlatformLogsQueryParamFilter withSourceTypes(String sourceTypes) {
        Utils.checkNotNull(sourceTypes, "sourceTypes");
        this.sourceTypes = JsonNullable.of(sourceTypes);
        return this;
    }

    /**
     * A comma-separated list of source types to filter the results by.
     */
    public StackoneListPlatformLogsQueryParamFilter withSourceTypes(JsonNullable<String> sourceTypes) {
        Utils.checkNotNull(sourceTypes, "sourceTypes");
        this.sourceTypes = sourceTypes;
        return this;
    }

    /**
     * A comma-separated list of source values to filter the results by.
     */
    public StackoneListPlatformLogsQueryParamFilter withSourceValues(String sourceValues) {
        Utils.checkNotNull(sourceValues, "sourceValues");
        this.sourceValues = JsonNullable.of(sourceValues);
        return this;
    }

    /**
     * A comma-separated list of source values to filter the results by.
     */
    public StackoneListPlatformLogsQueryParamFilter withSourceValues(JsonNullable<String> sourceValues) {
        Utils.checkNotNull(sourceValues, "sourceValues");
        this.sourceValues = sourceValues;
        return this;
    }

    /**
     * A comma-separated list of source IDs to filter the results by.
     */
    public StackoneListPlatformLogsQueryParamFilter withSourceIds(String sourceIds) {
        Utils.checkNotNull(sourceIds, "sourceIds");
        this.sourceIds = JsonNullable.of(sourceIds);
        return this;
    }

    /**
     * A comma-separated list of source IDs to filter the results by.
     */
    public StackoneListPlatformLogsQueryParamFilter withSourceIds(JsonNullable<String> sourceIds) {
        Utils.checkNotNull(sourceIds, "sourceIds");
        this.sourceIds = sourceIds;
        return this;
    }

    /**
     * A comma-separated list of HTTP methods to filter the results by.
     */
    public StackoneListPlatformLogsQueryParamFilter withHttpMethods(String httpMethods) {
        Utils.checkNotNull(httpMethods, "httpMethods");
        this.httpMethods = JsonNullable.of(httpMethods);
        return this;
    }

    /**
     * A comma-separated list of HTTP methods to filter the results by.
     */
    public StackoneListPlatformLogsQueryParamFilter withHttpMethods(JsonNullable<String> httpMethods) {
        Utils.checkNotNull(httpMethods, "httpMethods");
        this.httpMethods = httpMethods;
        return this;
    }

    /**
     * A comma-separated list of categories to filter the results by.
     */
    public StackoneListPlatformLogsQueryParamFilter withCategories(String categories) {
        Utils.checkNotNull(categories, "categories");
        this.categories = JsonNullable.of(categories);
        return this;
    }

    /**
     * A comma-separated list of categories to filter the results by.
     */
    public StackoneListPlatformLogsQueryParamFilter withCategories(JsonNullable<String> categories) {
        Utils.checkNotNull(categories, "categories");
        this.categories = categories;
        return this;
    }

    /**
     * A comma-separated list of resources to filter the results by.
     */
    public StackoneListPlatformLogsQueryParamFilter withResources(String resources) {
        Utils.checkNotNull(resources, "resources");
        this.resources = JsonNullable.of(resources);
        return this;
    }

    /**
     * A comma-separated list of resources to filter the results by.
     */
    public StackoneListPlatformLogsQueryParamFilter withResources(JsonNullable<String> resources) {
        Utils.checkNotNull(resources, "resources");
        this.resources = resources;
        return this;
    }

    /**
     * A comma-separated list of actions to filter the results by.
     */
    public StackoneListPlatformLogsQueryParamFilter withActions(String actions) {
        Utils.checkNotNull(actions, "actions");
        this.actions = JsonNullable.of(actions);
        return this;
    }

    /**
     * A comma-separated list of actions to filter the results by.
     */
    public StackoneListPlatformLogsQueryParamFilter withActions(JsonNullable<String> actions) {
        Utils.checkNotNull(actions, "actions");
        this.actions = actions;
        return this;
    }

    /**
     * A comma-separated list of status codes to filter the results by.
     */
    public StackoneListPlatformLogsQueryParamFilter withStatusCodes(String statusCodes) {
        Utils.checkNotNull(statusCodes, "statusCodes");
        this.statusCodes = JsonNullable.of(statusCodes);
        return this;
    }

    /**
     * A comma-separated list of status codes to filter the results by.
     */
    public StackoneListPlatformLogsQueryParamFilter withStatusCodes(JsonNullable<String> statusCodes) {
        Utils.checkNotNull(statusCodes, "statusCodes");
        this.statusCodes = statusCodes;
        return this;
    }

    /**
     * A boolean value to filter the results by success or failure.
     */
    public StackoneListPlatformLogsQueryParamFilter withSuccess(boolean success) {
        Utils.checkNotNull(success, "success");
        this.success = JsonNullable.of(success);
        return this;
    }

    /**
     * A boolean value to filter the results by success or failure.
     */
    public StackoneListPlatformLogsQueryParamFilter withSuccess(JsonNullable<Boolean> success) {
        Utils.checkNotNull(success, "success");
        this.success = success;
        return this;
    }

    /**
     * The field to order the results by.
     */
    public StackoneListPlatformLogsQueryParamFilter withOrderBy(StackoneListPlatformLogsQueryParamRequestLogsOrderBy orderBy) {
        Utils.checkNotNull(orderBy, "orderBy");
        this.orderBy = JsonNullable.of(orderBy);
        return this;
    }

    /**
     * The field to order the results by.
     */
    public StackoneListPlatformLogsQueryParamFilter withOrderBy(JsonNullable<? extends StackoneListPlatformLogsQueryParamRequestLogsOrderBy> orderBy) {
        Utils.checkNotNull(orderBy, "orderBy");
        this.orderBy = orderBy;
        return this;
    }

    /**
     * The direction to order the results by.
     */
    public StackoneListPlatformLogsQueryParamFilter withOrderDirection(StackoneListPlatformLogsQueryParamRequestLogsOrderDirection orderDirection) {
        Utils.checkNotNull(orderDirection, "orderDirection");
        this.orderDirection = JsonNullable.of(orderDirection);
        return this;
    }

    /**
     * The direction to order the results by.
     */
    public StackoneListPlatformLogsQueryParamFilter withOrderDirection(JsonNullable<? extends StackoneListPlatformLogsQueryParamRequestLogsOrderDirection> orderDirection) {
        Utils.checkNotNull(orderDirection, "orderDirection");
        this.orderDirection = orderDirection;
        return this;
    }

    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        StackoneListPlatformLogsQueryParamFilter other = (StackoneListPlatformLogsQueryParamFilter) o;
        return 
            Utils.enhancedDeepEquals(this.accountIds, other.accountIds) &&
            Utils.enhancedDeepEquals(this.startDate, other.startDate) &&
            Utils.enhancedDeepEquals(this.endDate, other.endDate) &&
            Utils.enhancedDeepEquals(this.requestIds, other.requestIds) &&
            Utils.enhancedDeepEquals(this.sourceTypes, other.sourceTypes) &&
            Utils.enhancedDeepEquals(this.sourceValues, other.sourceValues) &&
            Utils.enhancedDeepEquals(this.sourceIds, other.sourceIds) &&
            Utils.enhancedDeepEquals(this.httpMethods, other.httpMethods) &&
            Utils.enhancedDeepEquals(this.categories, other.categories) &&
            Utils.enhancedDeepEquals(this.resources, other.resources) &&
            Utils.enhancedDeepEquals(this.actions, other.actions) &&
            Utils.enhancedDeepEquals(this.statusCodes, other.statusCodes) &&
            Utils.enhancedDeepEquals(this.success, other.success) &&
            Utils.enhancedDeepEquals(this.orderBy, other.orderBy) &&
            Utils.enhancedDeepEquals(this.orderDirection, other.orderDirection);
    }
    
    @Override
    public int hashCode() {
        return Utils.enhancedHash(
            accountIds, startDate, endDate,
            requestIds, sourceTypes, sourceValues,
            sourceIds, httpMethods, categories,
            resources, actions, statusCodes,
            success, orderBy, orderDirection);
    }
    
    @Override
    public String toString() {
        return Utils.toString(StackoneListPlatformLogsQueryParamFilter.class,
                "accountIds", accountIds,
                "startDate", startDate,
                "endDate", endDate,
                "requestIds", requestIds,
                "sourceTypes", sourceTypes,
                "sourceValues", sourceValues,
                "sourceIds", sourceIds,
                "httpMethods", httpMethods,
                "categories", categories,
                "resources", resources,
                "actions", actions,
                "statusCodes", statusCodes,
                "success", success,
                "orderBy", orderBy,
                "orderDirection", orderDirection);
    }

    @SuppressWarnings("UnusedReturnValue")
    public final static class Builder {

        private JsonNullable<String> accountIds = JsonNullable.undefined();

        private JsonNullable<OffsetDateTime> startDate = JsonNullable.undefined();

        private JsonNullable<OffsetDateTime> endDate = JsonNullable.undefined();

        private JsonNullable<String> requestIds = JsonNullable.undefined();

        private JsonNullable<String> sourceTypes = JsonNullable.undefined();

        private JsonNullable<String> sourceValues = JsonNullable.undefined();

        private JsonNullable<String> sourceIds = JsonNullable.undefined();

        private JsonNullable<String> httpMethods = JsonNullable.undefined();

        private JsonNullable<String> categories = JsonNullable.undefined();

        private JsonNullable<String> resources = JsonNullable.undefined();

        private JsonNullable<String> actions = JsonNullable.undefined();

        private JsonNullable<String> statusCodes = JsonNullable.undefined();

        private JsonNullable<Boolean> success = JsonNullable.undefined();

        private JsonNullable<? extends StackoneListPlatformLogsQueryParamRequestLogsOrderBy> orderBy = JsonNullable.undefined();

        private JsonNullable<? extends StackoneListPlatformLogsQueryParamRequestLogsOrderDirection> orderDirection = JsonNullable.undefined();

        private Builder() {
          // force use of static builder() method
        }


        /**
         * A comma-separated list of account IDs to filter the results by.
         */
        public Builder accountIds(String accountIds) {
            Utils.checkNotNull(accountIds, "accountIds");
            this.accountIds = JsonNullable.of(accountIds);
            return this;
        }

        /**
         * A comma-separated list of account IDs to filter the results by.
         */
        public Builder accountIds(JsonNullable<String> accountIds) {
            Utils.checkNotNull(accountIds, "accountIds");
            this.accountIds = accountIds;
            return this;
        }


        /**
         * A ISO8601 date string to filter the results by start_date.
         */
        public Builder startDate(OffsetDateTime startDate) {
            Utils.checkNotNull(startDate, "startDate");
            this.startDate = JsonNullable.of(startDate);
            return this;
        }

        /**
         * A ISO8601 date string to filter the results by start_date.
         */
        public Builder startDate(JsonNullable<OffsetDateTime> startDate) {
            Utils.checkNotNull(startDate, "startDate");
            this.startDate = startDate;
            return this;
        }


        /**
         * A ISO8601 date string to filter the results by end_date.
         */
        public Builder endDate(OffsetDateTime endDate) {
            Utils.checkNotNull(endDate, "endDate");
            this.endDate = JsonNullable.of(endDate);
            return this;
        }

        /**
         * A ISO8601 date string to filter the results by end_date.
         */
        public Builder endDate(JsonNullable<OffsetDateTime> endDate) {
            Utils.checkNotNull(endDate, "endDate");
            this.endDate = endDate;
            return this;
        }


        /**
         * A comma-separated list of request IDs to filter the results by.
         */
        public Builder requestIds(String requestIds) {
            Utils.checkNotNull(requestIds, "requestIds");
            this.requestIds = JsonNullable.of(requestIds);
            return this;
        }

        /**
         * A comma-separated list of request IDs to filter the results by.
         */
        public Builder requestIds(JsonNullable<String> requestIds) {
            Utils.checkNotNull(requestIds, "requestIds");
            this.requestIds = requestIds;
            return this;
        }


        /**
         * A comma-separated list of source types to filter the results by.
         */
        public Builder sourceTypes(String sourceTypes) {
            Utils.checkNotNull(sourceTypes, "sourceTypes");
            this.sourceTypes = JsonNullable.of(sourceTypes);
            return this;
        }

        /**
         * A comma-separated list of source types to filter the results by.
         */
        public Builder sourceTypes(JsonNullable<String> sourceTypes) {
            Utils.checkNotNull(sourceTypes, "sourceTypes");
            this.sourceTypes = sourceTypes;
            return this;
        }


        /**
         * A comma-separated list of source values to filter the results by.
         */
        public Builder sourceValues(String sourceValues) {
            Utils.checkNotNull(sourceValues, "sourceValues");
            this.sourceValues = JsonNullable.of(sourceValues);
            return this;
        }

        /**
         * A comma-separated list of source values to filter the results by.
         */
        public Builder sourceValues(JsonNullable<String> sourceValues) {
            Utils.checkNotNull(sourceValues, "sourceValues");
            this.sourceValues = sourceValues;
            return this;
        }


        /**
         * A comma-separated list of source IDs to filter the results by.
         */
        public Builder sourceIds(String sourceIds) {
            Utils.checkNotNull(sourceIds, "sourceIds");
            this.sourceIds = JsonNullable.of(sourceIds);
            return this;
        }

        /**
         * A comma-separated list of source IDs to filter the results by.
         */
        public Builder sourceIds(JsonNullable<String> sourceIds) {
            Utils.checkNotNull(sourceIds, "sourceIds");
            this.sourceIds = sourceIds;
            return this;
        }


        /**
         * A comma-separated list of HTTP methods to filter the results by.
         */
        public Builder httpMethods(String httpMethods) {
            Utils.checkNotNull(httpMethods, "httpMethods");
            this.httpMethods = JsonNullable.of(httpMethods);
            return this;
        }

        /**
         * A comma-separated list of HTTP methods to filter the results by.
         */
        public Builder httpMethods(JsonNullable<String> httpMethods) {
            Utils.checkNotNull(httpMethods, "httpMethods");
            this.httpMethods = httpMethods;
            return this;
        }


        /**
         * A comma-separated list of categories to filter the results by.
         */
        public Builder categories(String categories) {
            Utils.checkNotNull(categories, "categories");
            this.categories = JsonNullable.of(categories);
            return this;
        }

        /**
         * A comma-separated list of categories to filter the results by.
         */
        public Builder categories(JsonNullable<String> categories) {
            Utils.checkNotNull(categories, "categories");
            this.categories = categories;
            return this;
        }


        /**
         * A comma-separated list of resources to filter the results by.
         */
        public Builder resources(String resources) {
            Utils.checkNotNull(resources, "resources");
            this.resources = JsonNullable.of(resources);
            return this;
        }

        /**
         * A comma-separated list of resources to filter the results by.
         */
        public Builder resources(JsonNullable<String> resources) {
            Utils.checkNotNull(resources, "resources");
            this.resources = resources;
            return this;
        }


        /**
         * A comma-separated list of actions to filter the results by.
         */
        public Builder actions(String actions) {
            Utils.checkNotNull(actions, "actions");
            this.actions = JsonNullable.of(actions);
            return this;
        }

        /**
         * A comma-separated list of actions to filter the results by.
         */
        public Builder actions(JsonNullable<String> actions) {
            Utils.checkNotNull(actions, "actions");
            this.actions = actions;
            return this;
        }


        /**
         * A comma-separated list of status codes to filter the results by.
         */
        public Builder statusCodes(String statusCodes) {
            Utils.checkNotNull(statusCodes, "statusCodes");
            this.statusCodes = JsonNullable.of(statusCodes);
            return this;
        }

        /**
         * A comma-separated list of status codes to filter the results by.
         */
        public Builder statusCodes(JsonNullable<String> statusCodes) {
            Utils.checkNotNull(statusCodes, "statusCodes");
            this.statusCodes = statusCodes;
            return this;
        }


        /**
         * A boolean value to filter the results by success or failure.
         */
        public Builder success(boolean success) {
            Utils.checkNotNull(success, "success");
            this.success = JsonNullable.of(success);
            return this;
        }

        /**
         * A boolean value to filter the results by success or failure.
         */
        public Builder success(JsonNullable<Boolean> success) {
            Utils.checkNotNull(success, "success");
            this.success = success;
            return this;
        }


        /**
         * The field to order the results by.
         */
        public Builder orderBy(StackoneListPlatformLogsQueryParamRequestLogsOrderBy orderBy) {
            Utils.checkNotNull(orderBy, "orderBy");
            this.orderBy = JsonNullable.of(orderBy);
            return this;
        }

        /**
         * The field to order the results by.
         */
        public Builder orderBy(JsonNullable<? extends StackoneListPlatformLogsQueryParamRequestLogsOrderBy> orderBy) {
            Utils.checkNotNull(orderBy, "orderBy");
            this.orderBy = orderBy;
            return this;
        }


        /**
         * The direction to order the results by.
         */
        public Builder orderDirection(StackoneListPlatformLogsQueryParamRequestLogsOrderDirection orderDirection) {
            Utils.checkNotNull(orderDirection, "orderDirection");
            this.orderDirection = JsonNullable.of(orderDirection);
            return this;
        }

        /**
         * The direction to order the results by.
         */
        public Builder orderDirection(JsonNullable<? extends StackoneListPlatformLogsQueryParamRequestLogsOrderDirection> orderDirection) {
            Utils.checkNotNull(orderDirection, "orderDirection");
            this.orderDirection = orderDirection;
            return this;
        }

        public StackoneListPlatformLogsQueryParamFilter build() {

            return new StackoneListPlatformLogsQueryParamFilter(
                accountIds, startDate, endDate,
                requestIds, sourceTypes, sourceValues,
                sourceIds, httpMethods, categories,
                resources, actions, statusCodes,
                success, orderBy, orderDirection);
        }

    }
}
