/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.stackone.stackone_client_java.utils.Utils;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import org.openapitools.jackson.nullable.JsonNullable;

/**
 * AccountingCompanyResultBaseCurrency
 * 
 * <p>Default currency for the company
 */
public class AccountingCompanyResultBaseCurrency {
    /**
     * Default currency for the company
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("value")
    private JsonNullable<? extends AccountingCompanyResultValue> value;


    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("source_value")
    private JsonNullable<? extends AccountingCompanyResultSourceValue> sourceValue;

    @JsonCreator
    public AccountingCompanyResultBaseCurrency(
            @JsonProperty("value") JsonNullable<? extends AccountingCompanyResultValue> value,
            @JsonProperty("source_value") JsonNullable<? extends AccountingCompanyResultSourceValue> sourceValue) {
        Utils.checkNotNull(value, "value");
        Utils.checkNotNull(sourceValue, "sourceValue");
        this.value = value;
        this.sourceValue = sourceValue;
    }
    
    public AccountingCompanyResultBaseCurrency() {
        this(JsonNullable.undefined(), JsonNullable.undefined());
    }

    /**
     * Default currency for the company
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<AccountingCompanyResultValue> value() {
        return (JsonNullable<AccountingCompanyResultValue>) value;
    }

    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<AccountingCompanyResultSourceValue> sourceValue() {
        return (JsonNullable<AccountingCompanyResultSourceValue>) sourceValue;
    }

    public static Builder builder() {
        return new Builder();
    }


    /**
     * Default currency for the company
     */
    public AccountingCompanyResultBaseCurrency withValue(AccountingCompanyResultValue value) {
        Utils.checkNotNull(value, "value");
        this.value = JsonNullable.of(value);
        return this;
    }

    /**
     * Default currency for the company
     */
    public AccountingCompanyResultBaseCurrency withValue(JsonNullable<? extends AccountingCompanyResultValue> value) {
        Utils.checkNotNull(value, "value");
        this.value = value;
        return this;
    }

    public AccountingCompanyResultBaseCurrency withSourceValue(AccountingCompanyResultSourceValue sourceValue) {
        Utils.checkNotNull(sourceValue, "sourceValue");
        this.sourceValue = JsonNullable.of(sourceValue);
        return this;
    }

    public AccountingCompanyResultBaseCurrency withSourceValue(JsonNullable<? extends AccountingCompanyResultSourceValue> sourceValue) {
        Utils.checkNotNull(sourceValue, "sourceValue");
        this.sourceValue = sourceValue;
        return this;
    }

    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        AccountingCompanyResultBaseCurrency other = (AccountingCompanyResultBaseCurrency) o;
        return 
            Utils.enhancedDeepEquals(this.value, other.value) &&
            Utils.enhancedDeepEquals(this.sourceValue, other.sourceValue);
    }
    
    @Override
    public int hashCode() {
        return Utils.enhancedHash(
            value, sourceValue);
    }
    
    @Override
    public String toString() {
        return Utils.toString(AccountingCompanyResultBaseCurrency.class,
                "value", value,
                "sourceValue", sourceValue);
    }

    @SuppressWarnings("UnusedReturnValue")
    public final static class Builder {

        private JsonNullable<? extends AccountingCompanyResultValue> value = JsonNullable.undefined();

        private JsonNullable<? extends AccountingCompanyResultSourceValue> sourceValue = JsonNullable.undefined();

        private Builder() {
          // force use of static builder() method
        }


        /**
         * Default currency for the company
         */
        public Builder value(AccountingCompanyResultValue value) {
            Utils.checkNotNull(value, "value");
            this.value = JsonNullable.of(value);
            return this;
        }

        /**
         * Default currency for the company
         */
        public Builder value(JsonNullable<? extends AccountingCompanyResultValue> value) {
            Utils.checkNotNull(value, "value");
            this.value = value;
            return this;
        }


        public Builder sourceValue(AccountingCompanyResultSourceValue sourceValue) {
            Utils.checkNotNull(sourceValue, "sourceValue");
            this.sourceValue = JsonNullable.of(sourceValue);
            return this;
        }

        public Builder sourceValue(JsonNullable<? extends AccountingCompanyResultSourceValue> sourceValue) {
            Utils.checkNotNull(sourceValue, "sourceValue");
            this.sourceValue = sourceValue;
            return this;
        }

        public AccountingCompanyResultBaseCurrency build() {

            return new AccountingCompanyResultBaseCurrency(
                value, sourceValue);
        }

    }
}
