/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java;

import static com.stackone.stackone_client_java.operations.Operations.AsyncRequestOperation;

import com.stackone.stackone_client_java.models.components.ConnectSessionAuthenticate;
import com.stackone.stackone_client_java.models.components.ConnectSessionCreate;
import com.stackone.stackone_client_java.models.operations.async.StackoneAuthenticateConnectSessionRequestBuilder;
import com.stackone.stackone_client_java.models.operations.async.StackoneAuthenticateConnectSessionResponse;
import com.stackone.stackone_client_java.models.operations.async.StackoneCreateConnectSessionRequestBuilder;
import com.stackone.stackone_client_java.models.operations.async.StackoneCreateConnectSessionResponse;
import com.stackone.stackone_client_java.operations.StackoneAuthenticateConnectSession;
import com.stackone.stackone_client_java.operations.StackoneCreateConnectSession;
import com.stackone.stackone_client_java.utils.Options;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;

/**
 * Generate connection session tokens or auth URLs to allow your customers to connect their accounts.
 */
public class AsyncConnectSessions {
    private final SDKConfiguration sdkConfiguration;
    private final ConnectSessions syncSDK;

    AsyncConnectSessions(ConnectSessions syncSDK, SDKConfiguration sdkConfiguration) {
        this.sdkConfiguration = sdkConfiguration;
        this.syncSDK = syncSDK;
    }

    /**
     * Switches to the sync SDK.
     * 
     * @return The sync SDK
     */
    public ConnectSessions sync() {
        return syncSDK;
    }


    /**
     * Create Connect Session
     * 
     * @return The async call builder
     */
    public StackoneCreateConnectSessionRequestBuilder createConnectSession() {
        return new StackoneCreateConnectSessionRequestBuilder(sdkConfiguration);
    }

    /**
     * Create Connect Session
     * 
     * @param request The request object containing all the parameters for the API call.
     * @return CompletableFuture&lt;StackoneCreateConnectSessionResponse&gt; - The async response
     */
    public CompletableFuture<StackoneCreateConnectSessionResponse> createConnectSession(ConnectSessionCreate request) {
        return createConnectSession(request, Optional.empty());
    }

    /**
     * Create Connect Session
     * 
     * @param request The request object containing all the parameters for the API call.
     * @param options additional options
     * @return CompletableFuture&lt;StackoneCreateConnectSessionResponse&gt; - The async response
     */
    public CompletableFuture<StackoneCreateConnectSessionResponse> createConnectSession(ConnectSessionCreate request, Optional<Options> options) {
        AsyncRequestOperation<ConnectSessionCreate, StackoneCreateConnectSessionResponse> operation
              = new StackoneCreateConnectSession.Async(sdkConfiguration, options, sdkConfiguration.retryScheduler());
        return operation.doRequest(request)
            .thenCompose(operation::handleResponse);
    }


    /**
     * Authenticate Connect Session
     * 
     * @return The async call builder
     */
    public StackoneAuthenticateConnectSessionRequestBuilder authenticateConnectSession() {
        return new StackoneAuthenticateConnectSessionRequestBuilder(sdkConfiguration);
    }

    /**
     * Authenticate Connect Session
     * 
     * @param request The request object containing all the parameters for the API call.
     * @return CompletableFuture&lt;StackoneAuthenticateConnectSessionResponse&gt; - The async response
     */
    public CompletableFuture<StackoneAuthenticateConnectSessionResponse> authenticateConnectSession(ConnectSessionAuthenticate request) {
        return authenticateConnectSession(request, Optional.empty());
    }

    /**
     * Authenticate Connect Session
     * 
     * @param request The request object containing all the parameters for the API call.
     * @param options additional options
     * @return CompletableFuture&lt;StackoneAuthenticateConnectSessionResponse&gt; - The async response
     */
    public CompletableFuture<StackoneAuthenticateConnectSessionResponse> authenticateConnectSession(ConnectSessionAuthenticate request, Optional<Options> options) {
        AsyncRequestOperation<ConnectSessionAuthenticate, StackoneAuthenticateConnectSessionResponse> operation
              = new StackoneAuthenticateConnectSession.Async(sdkConfiguration, options, sdkConfiguration.retryScheduler());
        return operation.doRequest(request)
            .thenCompose(operation::handleResponse);
    }

}
