/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.stackone.stackone_client_java.utils.Utils;
import java.lang.Double;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.time.OffsetDateTime;
import java.util.List;
import org.openapitools.jackson.nullable.JsonNullable;


public class AccountingJournalCreateRequestDto {
    /**
     * Reference number for the journal
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("reference")
    private JsonNullable<String> reference;

    /**
     * Memo or description for the journal
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("memo")
    private JsonNullable<String> memo;

    /**
     * Currency code for the journal and all lines
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("currency_code")
    private JsonNullable<? extends CurrencyCode> currencyCode;

    /**
     * Exchange rate to company base currency to apply to all lines
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("exchange_rate")
    private JsonNullable<Double> exchangeRate;

    /**
     * Date of the journal transaction
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("transaction_date")
    private JsonNullable<OffsetDateTime> transactionDate;

    /**
     * List of journal lines
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("lines")
    private JsonNullable<? extends List<CreateJournalLine>> lines;

    @JsonCreator
    public AccountingJournalCreateRequestDto(
            @JsonProperty("reference") JsonNullable<String> reference,
            @JsonProperty("memo") JsonNullable<String> memo,
            @JsonProperty("currency_code") JsonNullable<? extends CurrencyCode> currencyCode,
            @JsonProperty("exchange_rate") JsonNullable<Double> exchangeRate,
            @JsonProperty("transaction_date") JsonNullable<OffsetDateTime> transactionDate,
            @JsonProperty("lines") JsonNullable<? extends List<CreateJournalLine>> lines) {
        Utils.checkNotNull(reference, "reference");
        Utils.checkNotNull(memo, "memo");
        Utils.checkNotNull(currencyCode, "currencyCode");
        Utils.checkNotNull(exchangeRate, "exchangeRate");
        Utils.checkNotNull(transactionDate, "transactionDate");
        Utils.checkNotNull(lines, "lines");
        this.reference = reference;
        this.memo = memo;
        this.currencyCode = currencyCode;
        this.exchangeRate = exchangeRate;
        this.transactionDate = transactionDate;
        this.lines = lines;
    }
    
    public AccountingJournalCreateRequestDto() {
        this(JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(),
            JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined());
    }

    /**
     * Reference number for the journal
     */
    @JsonIgnore
    public JsonNullable<String> reference() {
        return reference;
    }

    /**
     * Memo or description for the journal
     */
    @JsonIgnore
    public JsonNullable<String> memo() {
        return memo;
    }

    /**
     * Currency code for the journal and all lines
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<CurrencyCode> currencyCode() {
        return (JsonNullable<CurrencyCode>) currencyCode;
    }

    /**
     * Exchange rate to company base currency to apply to all lines
     */
    @JsonIgnore
    public JsonNullable<Double> exchangeRate() {
        return exchangeRate;
    }

    /**
     * Date of the journal transaction
     */
    @JsonIgnore
    public JsonNullable<OffsetDateTime> transactionDate() {
        return transactionDate;
    }

    /**
     * List of journal lines
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<List<CreateJournalLine>> lines() {
        return (JsonNullable<List<CreateJournalLine>>) lines;
    }

    public static Builder builder() {
        return new Builder();
    }


    /**
     * Reference number for the journal
     */
    public AccountingJournalCreateRequestDto withReference(String reference) {
        Utils.checkNotNull(reference, "reference");
        this.reference = JsonNullable.of(reference);
        return this;
    }

    /**
     * Reference number for the journal
     */
    public AccountingJournalCreateRequestDto withReference(JsonNullable<String> reference) {
        Utils.checkNotNull(reference, "reference");
        this.reference = reference;
        return this;
    }

    /**
     * Memo or description for the journal
     */
    public AccountingJournalCreateRequestDto withMemo(String memo) {
        Utils.checkNotNull(memo, "memo");
        this.memo = JsonNullable.of(memo);
        return this;
    }

    /**
     * Memo or description for the journal
     */
    public AccountingJournalCreateRequestDto withMemo(JsonNullable<String> memo) {
        Utils.checkNotNull(memo, "memo");
        this.memo = memo;
        return this;
    }

    /**
     * Currency code for the journal and all lines
     */
    public AccountingJournalCreateRequestDto withCurrencyCode(CurrencyCode currencyCode) {
        Utils.checkNotNull(currencyCode, "currencyCode");
        this.currencyCode = JsonNullable.of(currencyCode);
        return this;
    }

    /**
     * Currency code for the journal and all lines
     */
    public AccountingJournalCreateRequestDto withCurrencyCode(JsonNullable<? extends CurrencyCode> currencyCode) {
        Utils.checkNotNull(currencyCode, "currencyCode");
        this.currencyCode = currencyCode;
        return this;
    }

    /**
     * Exchange rate to company base currency to apply to all lines
     */
    public AccountingJournalCreateRequestDto withExchangeRate(double exchangeRate) {
        Utils.checkNotNull(exchangeRate, "exchangeRate");
        this.exchangeRate = JsonNullable.of(exchangeRate);
        return this;
    }

    /**
     * Exchange rate to company base currency to apply to all lines
     */
    public AccountingJournalCreateRequestDto withExchangeRate(JsonNullable<Double> exchangeRate) {
        Utils.checkNotNull(exchangeRate, "exchangeRate");
        this.exchangeRate = exchangeRate;
        return this;
    }

    /**
     * Date of the journal transaction
     */
    public AccountingJournalCreateRequestDto withTransactionDate(OffsetDateTime transactionDate) {
        Utils.checkNotNull(transactionDate, "transactionDate");
        this.transactionDate = JsonNullable.of(transactionDate);
        return this;
    }

    /**
     * Date of the journal transaction
     */
    public AccountingJournalCreateRequestDto withTransactionDate(JsonNullable<OffsetDateTime> transactionDate) {
        Utils.checkNotNull(transactionDate, "transactionDate");
        this.transactionDate = transactionDate;
        return this;
    }

    /**
     * List of journal lines
     */
    public AccountingJournalCreateRequestDto withLines(List<CreateJournalLine> lines) {
        Utils.checkNotNull(lines, "lines");
        this.lines = JsonNullable.of(lines);
        return this;
    }

    /**
     * List of journal lines
     */
    public AccountingJournalCreateRequestDto withLines(JsonNullable<? extends List<CreateJournalLine>> lines) {
        Utils.checkNotNull(lines, "lines");
        this.lines = lines;
        return this;
    }

    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        AccountingJournalCreateRequestDto other = (AccountingJournalCreateRequestDto) o;
        return 
            Utils.enhancedDeepEquals(this.reference, other.reference) &&
            Utils.enhancedDeepEquals(this.memo, other.memo) &&
            Utils.enhancedDeepEquals(this.currencyCode, other.currencyCode) &&
            Utils.enhancedDeepEquals(this.exchangeRate, other.exchangeRate) &&
            Utils.enhancedDeepEquals(this.transactionDate, other.transactionDate) &&
            Utils.enhancedDeepEquals(this.lines, other.lines);
    }
    
    @Override
    public int hashCode() {
        return Utils.enhancedHash(
            reference, memo, currencyCode,
            exchangeRate, transactionDate, lines);
    }
    
    @Override
    public String toString() {
        return Utils.toString(AccountingJournalCreateRequestDto.class,
                "reference", reference,
                "memo", memo,
                "currencyCode", currencyCode,
                "exchangeRate", exchangeRate,
                "transactionDate", transactionDate,
                "lines", lines);
    }

    @SuppressWarnings("UnusedReturnValue")
    public final static class Builder {

        private JsonNullable<String> reference = JsonNullable.undefined();

        private JsonNullable<String> memo = JsonNullable.undefined();

        private JsonNullable<? extends CurrencyCode> currencyCode = JsonNullable.undefined();

        private JsonNullable<Double> exchangeRate = JsonNullable.undefined();

        private JsonNullable<OffsetDateTime> transactionDate = JsonNullable.undefined();

        private JsonNullable<? extends List<CreateJournalLine>> lines = JsonNullable.undefined();

        private Builder() {
          // force use of static builder() method
        }


        /**
         * Reference number for the journal
         */
        public Builder reference(String reference) {
            Utils.checkNotNull(reference, "reference");
            this.reference = JsonNullable.of(reference);
            return this;
        }

        /**
         * Reference number for the journal
         */
        public Builder reference(JsonNullable<String> reference) {
            Utils.checkNotNull(reference, "reference");
            this.reference = reference;
            return this;
        }


        /**
         * Memo or description for the journal
         */
        public Builder memo(String memo) {
            Utils.checkNotNull(memo, "memo");
            this.memo = JsonNullable.of(memo);
            return this;
        }

        /**
         * Memo or description for the journal
         */
        public Builder memo(JsonNullable<String> memo) {
            Utils.checkNotNull(memo, "memo");
            this.memo = memo;
            return this;
        }


        /**
         * Currency code for the journal and all lines
         */
        public Builder currencyCode(CurrencyCode currencyCode) {
            Utils.checkNotNull(currencyCode, "currencyCode");
            this.currencyCode = JsonNullable.of(currencyCode);
            return this;
        }

        /**
         * Currency code for the journal and all lines
         */
        public Builder currencyCode(JsonNullable<? extends CurrencyCode> currencyCode) {
            Utils.checkNotNull(currencyCode, "currencyCode");
            this.currencyCode = currencyCode;
            return this;
        }


        /**
         * Exchange rate to company base currency to apply to all lines
         */
        public Builder exchangeRate(double exchangeRate) {
            Utils.checkNotNull(exchangeRate, "exchangeRate");
            this.exchangeRate = JsonNullable.of(exchangeRate);
            return this;
        }

        /**
         * Exchange rate to company base currency to apply to all lines
         */
        public Builder exchangeRate(JsonNullable<Double> exchangeRate) {
            Utils.checkNotNull(exchangeRate, "exchangeRate");
            this.exchangeRate = exchangeRate;
            return this;
        }


        /**
         * Date of the journal transaction
         */
        public Builder transactionDate(OffsetDateTime transactionDate) {
            Utils.checkNotNull(transactionDate, "transactionDate");
            this.transactionDate = JsonNullable.of(transactionDate);
            return this;
        }

        /**
         * Date of the journal transaction
         */
        public Builder transactionDate(JsonNullable<OffsetDateTime> transactionDate) {
            Utils.checkNotNull(transactionDate, "transactionDate");
            this.transactionDate = transactionDate;
            return this;
        }


        /**
         * List of journal lines
         */
        public Builder lines(List<CreateJournalLine> lines) {
            Utils.checkNotNull(lines, "lines");
            this.lines = JsonNullable.of(lines);
            return this;
        }

        /**
         * List of journal lines
         */
        public Builder lines(JsonNullable<? extends List<CreateJournalLine>> lines) {
            Utils.checkNotNull(lines, "lines");
            this.lines = lines;
            return this;
        }

        public AccountingJournalCreateRequestDto build() {

            return new AccountingJournalCreateRequestDto(
                reference, memo, currencyCode,
                exchangeRate, transactionDate, lines);
        }

    }
}
