/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java.models.operations.async;

import static com.stackone.stackone_client_java.operations.Operations.AsyncRequestOperation;
import static com.stackone.stackone_client_java.utils.reactive.ReactiveUtils.mapAsync;

import com.stackone.stackone_client_java.SDKConfiguration;
import com.stackone.stackone_client_java.models.operations.HrisListTasksRequest;
import com.stackone.stackone_client_java.operations.HrisListTasks;
import com.stackone.stackone_client_java.utils.Blob;
import com.stackone.stackone_client_java.utils.Options;
import com.stackone.stackone_client_java.utils.RetryConfig;
import com.stackone.stackone_client_java.utils.Utils;
import com.stackone.stackone_client_java.utils.pagination.AsyncPaginator;
import com.stackone.stackone_client_java.utils.pagination.CursorTracker;
import java.lang.Exception;
import java.lang.String;
import java.net.http.HttpResponse;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Flow;
import org.reactivestreams.FlowAdapters;
import org.reactivestreams.Publisher;

public class HrisListTasksRequestBuilder {

    private HrisListTasksRequest request;
    private Optional<RetryConfig> retryConfig = Optional.empty();
    private final SDKConfiguration sdkConfiguration;

    public HrisListTasksRequestBuilder(SDKConfiguration sdkConfiguration) {
        this.sdkConfiguration = sdkConfiguration;
    }

    public HrisListTasksRequestBuilder request(HrisListTasksRequest request) {
        Utils.checkNotNull(request, "request");
        this.request = request;
        return this;
    }
                
    public HrisListTasksRequestBuilder retryConfig(RetryConfig retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = Optional.of(retryConfig);
        return this;
    }

    public HrisListTasksRequestBuilder retryConfig(Optional<RetryConfig> retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = retryConfig;
        return this;
    }

    public CompletableFuture<HrisListTasksResponse> call() throws Exception {
        Optional<Options> options = Optional.of(Options.builder()
            .retryConfig(retryConfig)
            .build());

        AsyncRequestOperation<HrisListTasksRequest, HrisListTasksResponse> operation
              = new HrisListTasks.Async(sdkConfiguration, options, sdkConfiguration.retryScheduler());

        return operation.doRequest(request)
            .thenCompose(operation::handleResponse);
    }

    /**
     * Returns a Publisher that performs next page calls till no more pages
     * are returned.
     *
     * <p>The returned publisher can be used with reactive frameworks:
     * <pre><code>
     * Publisher&lt;HrisListTasksResponse&gt; publisher = builder.callAsPublisher();
     * publisher.subscribe(new Subscriber&lt;HrisListTasksResponse&gt;() {
     *     // Handle onNext, onError, onComplete
     * });
     * </code></pre>
     *
     * @return A Publisher that emits pages asynchronously
     */
    public Publisher<HrisListTasksResponse> callAsPublisher() {
        HrisListTasksRequest request = this.request;
        Optional<Options> options = Optional.of(Options.builder()
            .retryConfig(retryConfig)
            .build());

        AsyncRequestOperation<HrisListTasksRequest, HrisListTasksResponse> operation
              = new HrisListTasks.Async(sdkConfiguration, options, sdkConfiguration.retryScheduler());

        Flow.Publisher<HttpResponse<Blob>> asyncPaginator = new AsyncPaginator<>(
            request,
            new CursorTracker<>("$.next", String.class),
                    HrisListTasksRequest::withNext,
            operation::doRequest);

        Flow.Publisher<HrisListTasksResponse> flowPublisher = mapAsync(asyncPaginator, operation::handleResponse);

        // Convert Flow.Publisher to Reactive Streams Publisher at the last stage
        return FlowAdapters.toPublisher(flowPublisher);
    }

}
