/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.operations.async;

import com.stackone.stackone_client_java.SDKConfiguration;
import com.stackone.stackone_client_java.models.operations.AtsListLocationsRequest;
import com.stackone.stackone_client_java.models.operations.async.AtsListLocationsResponse;
import com.stackone.stackone_client_java.operations.AtsListLocations;
import com.stackone.stackone_client_java.utils.Options;
import com.stackone.stackone_client_java.utils.RetryConfig;
import com.stackone.stackone_client_java.utils.Utils;
import com.stackone.stackone_client_java.utils.pagination.AsyncPaginator;
import com.stackone.stackone_client_java.utils.pagination.CursorTracker;
import com.stackone.stackone_client_java.utils.reactive.ReactiveUtils;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Flow;
import org.reactivestreams.FlowAdapters;
import org.reactivestreams.Publisher;

public class AtsListLocationsRequestBuilder {
    private AtsListLocationsRequest request;
    private Optional<RetryConfig> retryConfig = Optional.empty();
    private final SDKConfiguration sdkConfiguration;

    public AtsListLocationsRequestBuilder(SDKConfiguration sdkConfiguration) {
        this.sdkConfiguration = sdkConfiguration;
    }

    public AtsListLocationsRequestBuilder request(AtsListLocationsRequest request) {
        Utils.checkNotNull(request, "request");
        this.request = request;
        return this;
    }

    public AtsListLocationsRequestBuilder retryConfig(RetryConfig retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = Optional.of(retryConfig);
        return this;
    }

    public AtsListLocationsRequestBuilder retryConfig(Optional<RetryConfig> retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = retryConfig;
        return this;
    }

    public CompletableFuture<AtsListLocationsResponse> call() throws Exception {
        Optional<Options> options = Optional.of(Options.builder().retryConfig(this.retryConfig).build());
        AtsListLocations.Async operation = new AtsListLocations.Async(this.sdkConfiguration, options, this.sdkConfiguration.retryScheduler());
        return operation.doRequest(this.request).thenCompose(operation::handleResponse);
    }

    public Publisher<AtsListLocationsResponse> callAsPublisher() {
        AtsListLocationsRequest request = this.request;
        Optional<Options> options = Optional.of(Options.builder().retryConfig(this.retryConfig).build());
        AtsListLocations.Async operation = new AtsListLocations.Async(this.sdkConfiguration, options, this.sdkConfiguration.retryScheduler());
        AsyncPaginator<AtsListLocationsRequest, String> asyncPaginator = new AsyncPaginator<AtsListLocationsRequest, String>(request, new CursorTracker<String>("$.next", String.class), AtsListLocationsRequest::withNext, operation::doRequest);
        Flow.Publisher flowPublisher = ReactiveUtils.mapAsync(asyncPaginator, operation::handleResponse);
        return FlowAdapters.toPublisher(flowPublisher);
    }
}

