/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java.operations;

import com.stackone.stackone_client_java.utils.Blob;

import java.io.InputStream;
import java.net.http.HttpResponse;
import java.util.concurrent.CompletableFuture;

// Internal API only

public class Operations {
    /**
    * Base interface for all operations
    */
    public interface Operation<ResT> {
        ResT handleResponse(HttpResponse<InputStream> response) throws Exception;
    }

    /**
    * Interface for operations that require a request parameter
    */
    public interface RequestOperation<ReqT, ResT> extends Operation<ResT> {
        HttpResponse<InputStream> doRequest(ReqT request) throws Exception;
    }

    /**
    * Interface for operations that don't require a request parameter
    */
    public interface RequestlessOperation<ResT> extends Operation<ResT> {
        HttpResponse<InputStream> doRequest() throws Exception;
    }

    /**
    * Base interface for all async operations
    */
    public interface AsyncOperation<ResT> {
        CompletableFuture<ResT> handleResponse(HttpResponse<Blob> response);
    }

    /**
    * Interface for async operations that require a request parameter
    */
    public interface AsyncRequestOperation<ReqT, ResT> extends AsyncOperation<ResT> {
        CompletableFuture<HttpResponse<Blob>> doRequest(ReqT request);
    }

    /**
    * Interface for async operations that don't require a request parameter
    */
    public interface AsyncRequestlessOperation<ResT> extends AsyncOperation<ResT> {
        CompletableFuture<HttpResponse<Blob>> doRequest();
    }
}