/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.operations;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.stackone.stackone_client_java.models.components.DrivesPaginated;
import com.stackone.stackone_client_java.utils.Response;
import com.stackone.stackone_client_java.utils.Utils;
import java.io.InputStream;
import java.net.http.HttpResponse;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class DocumentsListDrivesResponse
implements Response {
    private String contentType;
    private int statusCode;
    private HttpResponse<InputStream> rawResponse;
    private Optional<? extends DrivesPaginated> drivesPaginated;
    private Map<String, List<String>> headers;

    @JsonCreator
    public DocumentsListDrivesResponse(String contentType, int statusCode, HttpResponse<InputStream> rawResponse, Optional<? extends DrivesPaginated> drivesPaginated, Map<String, List<String>> headers) {
        Utils.checkNotNull(contentType, "contentType");
        Utils.checkNotNull(statusCode, "statusCode");
        Utils.checkNotNull(rawResponse, "rawResponse");
        Utils.checkNotNull(drivesPaginated, "drivesPaginated");
        headers = Utils.emptyMapIfNull(headers);
        Utils.checkNotNull(headers, "headers");
        this.contentType = contentType;
        this.statusCode = statusCode;
        this.rawResponse = rawResponse;
        this.drivesPaginated = drivesPaginated;
        this.headers = headers;
    }

    public DocumentsListDrivesResponse(String contentType, int statusCode, HttpResponse<InputStream> rawResponse, Map<String, List<String>> headers) {
        this(contentType, statusCode, rawResponse, Optional.empty(), headers);
    }

    @Override
    @JsonIgnore
    public String contentType() {
        return this.contentType;
    }

    @Override
    @JsonIgnore
    public int statusCode() {
        return this.statusCode;
    }

    @Override
    @JsonIgnore
    public HttpResponse<InputStream> rawResponse() {
        return this.rawResponse;
    }

    @JsonIgnore
    public Optional<DrivesPaginated> drivesPaginated() {
        return this.drivesPaginated;
    }

    @JsonIgnore
    public Map<String, List<String>> headers() {
        return this.headers;
    }

    public static Builder builder() {
        return new Builder();
    }

    public DocumentsListDrivesResponse withContentType(String contentType) {
        Utils.checkNotNull(contentType, "contentType");
        this.contentType = contentType;
        return this;
    }

    public DocumentsListDrivesResponse withStatusCode(int statusCode) {
        Utils.checkNotNull(statusCode, "statusCode");
        this.statusCode = statusCode;
        return this;
    }

    public DocumentsListDrivesResponse withRawResponse(HttpResponse<InputStream> rawResponse) {
        Utils.checkNotNull(rawResponse, "rawResponse");
        this.rawResponse = rawResponse;
        return this;
    }

    public DocumentsListDrivesResponse withDrivesPaginated(DrivesPaginated drivesPaginated) {
        Utils.checkNotNull(drivesPaginated, "drivesPaginated");
        this.drivesPaginated = Optional.ofNullable(drivesPaginated);
        return this;
    }

    public DocumentsListDrivesResponse withDrivesPaginated(Optional<? extends DrivesPaginated> drivesPaginated) {
        Utils.checkNotNull(drivesPaginated, "drivesPaginated");
        this.drivesPaginated = drivesPaginated;
        return this;
    }

    public DocumentsListDrivesResponse withHeaders(Map<String, List<String>> headers) {
        Utils.checkNotNull(headers, "headers");
        this.headers = headers;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DocumentsListDrivesResponse other = (DocumentsListDrivesResponse)o;
        return Utils.enhancedDeepEquals(this.contentType, other.contentType) && Utils.enhancedDeepEquals(this.statusCode, other.statusCode) && Utils.enhancedDeepEquals(this.rawResponse, other.rawResponse) && Utils.enhancedDeepEquals(this.drivesPaginated, other.drivesPaginated) && Utils.enhancedDeepEquals(this.headers, other.headers);
    }

    public int hashCode() {
        return Utils.enhancedHash(this.contentType, this.statusCode, this.rawResponse, this.drivesPaginated, this.headers);
    }

    public String toString() {
        return Utils.toString(DocumentsListDrivesResponse.class, "contentType", this.contentType, "statusCode", this.statusCode, "rawResponse", this.rawResponse, "drivesPaginated", this.drivesPaginated, "headers", this.headers);
    }

    public static final class Builder {
        private String contentType;
        private Integer statusCode;
        private HttpResponse<InputStream> rawResponse;
        private Optional<? extends DrivesPaginated> drivesPaginated = Optional.empty();
        private Map<String, List<String>> headers;

        private Builder() {
        }

        public Builder contentType(String contentType) {
            Utils.checkNotNull(contentType, "contentType");
            this.contentType = contentType;
            return this;
        }

        public Builder statusCode(int statusCode) {
            Utils.checkNotNull(statusCode, "statusCode");
            this.statusCode = statusCode;
            return this;
        }

        public Builder rawResponse(HttpResponse<InputStream> rawResponse) {
            Utils.checkNotNull(rawResponse, "rawResponse");
            this.rawResponse = rawResponse;
            return this;
        }

        public Builder drivesPaginated(DrivesPaginated drivesPaginated) {
            Utils.checkNotNull(drivesPaginated, "drivesPaginated");
            this.drivesPaginated = Optional.ofNullable(drivesPaginated);
            return this;
        }

        public Builder drivesPaginated(Optional<? extends DrivesPaginated> drivesPaginated) {
            Utils.checkNotNull(drivesPaginated, "drivesPaginated");
            this.drivesPaginated = drivesPaginated;
            return this;
        }

        public Builder headers(Map<String, List<String>> headers) {
            Utils.checkNotNull(headers, "headers");
            this.headers = headers;
            return this;
        }

        public DocumentsListDrivesResponse build() {
            return new DocumentsListDrivesResponse(this.contentType, this.statusCode, this.rawResponse, this.drivesPaginated, this.headers);
        }
    }
}

