/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.operations;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.stackone.stackone_client_java.models.components.FoldersPaginated;
import com.stackone.stackone_client_java.utils.Response;
import com.stackone.stackone_client_java.utils.Utils;
import java.io.InputStream;
import java.net.http.HttpResponse;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class DocumentsListFoldersResponse
implements Response {
    private String contentType;
    private int statusCode;
    private HttpResponse<InputStream> rawResponse;
    private Optional<? extends FoldersPaginated> foldersPaginated;
    private Map<String, List<String>> headers;

    @JsonCreator
    public DocumentsListFoldersResponse(String contentType, int statusCode, HttpResponse<InputStream> rawResponse, Optional<? extends FoldersPaginated> foldersPaginated, Map<String, List<String>> headers) {
        Utils.checkNotNull(contentType, "contentType");
        Utils.checkNotNull(statusCode, "statusCode");
        Utils.checkNotNull(rawResponse, "rawResponse");
        Utils.checkNotNull(foldersPaginated, "foldersPaginated");
        headers = Utils.emptyMapIfNull(headers);
        Utils.checkNotNull(headers, "headers");
        this.contentType = contentType;
        this.statusCode = statusCode;
        this.rawResponse = rawResponse;
        this.foldersPaginated = foldersPaginated;
        this.headers = headers;
    }

    public DocumentsListFoldersResponse(String contentType, int statusCode, HttpResponse<InputStream> rawResponse, Map<String, List<String>> headers) {
        this(contentType, statusCode, rawResponse, Optional.empty(), headers);
    }

    @Override
    @JsonIgnore
    public String contentType() {
        return this.contentType;
    }

    @Override
    @JsonIgnore
    public int statusCode() {
        return this.statusCode;
    }

    @Override
    @JsonIgnore
    public HttpResponse<InputStream> rawResponse() {
        return this.rawResponse;
    }

    @JsonIgnore
    public Optional<FoldersPaginated> foldersPaginated() {
        return this.foldersPaginated;
    }

    @JsonIgnore
    public Map<String, List<String>> headers() {
        return this.headers;
    }

    public static Builder builder() {
        return new Builder();
    }

    public DocumentsListFoldersResponse withContentType(String contentType) {
        Utils.checkNotNull(contentType, "contentType");
        this.contentType = contentType;
        return this;
    }

    public DocumentsListFoldersResponse withStatusCode(int statusCode) {
        Utils.checkNotNull(statusCode, "statusCode");
        this.statusCode = statusCode;
        return this;
    }

    public DocumentsListFoldersResponse withRawResponse(HttpResponse<InputStream> rawResponse) {
        Utils.checkNotNull(rawResponse, "rawResponse");
        this.rawResponse = rawResponse;
        return this;
    }

    public DocumentsListFoldersResponse withFoldersPaginated(FoldersPaginated foldersPaginated) {
        Utils.checkNotNull(foldersPaginated, "foldersPaginated");
        this.foldersPaginated = Optional.ofNullable(foldersPaginated);
        return this;
    }

    public DocumentsListFoldersResponse withFoldersPaginated(Optional<? extends FoldersPaginated> foldersPaginated) {
        Utils.checkNotNull(foldersPaginated, "foldersPaginated");
        this.foldersPaginated = foldersPaginated;
        return this;
    }

    public DocumentsListFoldersResponse withHeaders(Map<String, List<String>> headers) {
        Utils.checkNotNull(headers, "headers");
        this.headers = headers;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DocumentsListFoldersResponse other = (DocumentsListFoldersResponse)o;
        return Utils.enhancedDeepEquals(this.contentType, other.contentType) && Utils.enhancedDeepEquals(this.statusCode, other.statusCode) && Utils.enhancedDeepEquals(this.rawResponse, other.rawResponse) && Utils.enhancedDeepEquals(this.foldersPaginated, other.foldersPaginated) && Utils.enhancedDeepEquals(this.headers, other.headers);
    }

    public int hashCode() {
        return Utils.enhancedHash(this.contentType, this.statusCode, this.rawResponse, this.foldersPaginated, this.headers);
    }

    public String toString() {
        return Utils.toString(DocumentsListFoldersResponse.class, "contentType", this.contentType, "statusCode", this.statusCode, "rawResponse", this.rawResponse, "foldersPaginated", this.foldersPaginated, "headers", this.headers);
    }

    public static final class Builder {
        private String contentType;
        private Integer statusCode;
        private HttpResponse<InputStream> rawResponse;
        private Optional<? extends FoldersPaginated> foldersPaginated = Optional.empty();
        private Map<String, List<String>> headers;

        private Builder() {
        }

        public Builder contentType(String contentType) {
            Utils.checkNotNull(contentType, "contentType");
            this.contentType = contentType;
            return this;
        }

        public Builder statusCode(int statusCode) {
            Utils.checkNotNull(statusCode, "statusCode");
            this.statusCode = statusCode;
            return this;
        }

        public Builder rawResponse(HttpResponse<InputStream> rawResponse) {
            Utils.checkNotNull(rawResponse, "rawResponse");
            this.rawResponse = rawResponse;
            return this;
        }

        public Builder foldersPaginated(FoldersPaginated foldersPaginated) {
            Utils.checkNotNull(foldersPaginated, "foldersPaginated");
            this.foldersPaginated = Optional.ofNullable(foldersPaginated);
            return this;
        }

        public Builder foldersPaginated(Optional<? extends FoldersPaginated> foldersPaginated) {
            Utils.checkNotNull(foldersPaginated, "foldersPaginated");
            this.foldersPaginated = foldersPaginated;
            return this;
        }

        public Builder headers(Map<String, List<String>> headers) {
            Utils.checkNotNull(headers, "headers");
            this.headers = headers;
            return this;
        }

        public DocumentsListFoldersResponse build() {
            return new DocumentsListFoldersResponse(this.contentType, this.statusCode, this.rawResponse, this.foldersPaginated, this.headers);
        }
    }
}

