/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.stackone.stackone_client_java.utils.Utils;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import org.openapitools.jackson.nullable.JsonNullable;

/**
 * HrisUpdateEmploymentRequestDtoType
 * 
 * <p>The type of employment
 */
public class HrisUpdateEmploymentRequestDtoType {
    /**
     * Unique identifier
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("id")
    private JsonNullable<String> id;

    /**
     * Provider's unique identifier
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("remote_id")
    private JsonNullable<String> remoteId;

    /**
     * The label of the employment type
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("label")
    private JsonNullable<String> label;

    /**
     * The type of employment (e.g., contractor, permanent)
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("type")
    private JsonNullable<? extends HrisUpdateEmploymentRequestDtoTypeType> type;

    @JsonCreator
    public HrisUpdateEmploymentRequestDtoType(
            @JsonProperty("id") JsonNullable<String> id,
            @JsonProperty("remote_id") JsonNullable<String> remoteId,
            @JsonProperty("label") JsonNullable<String> label,
            @JsonProperty("type") JsonNullable<? extends HrisUpdateEmploymentRequestDtoTypeType> type) {
        Utils.checkNotNull(id, "id");
        Utils.checkNotNull(remoteId, "remoteId");
        Utils.checkNotNull(label, "label");
        Utils.checkNotNull(type, "type");
        this.id = id;
        this.remoteId = remoteId;
        this.label = label;
        this.type = type;
    }
    
    public HrisUpdateEmploymentRequestDtoType() {
        this(JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(),
            JsonNullable.undefined());
    }

    /**
     * Unique identifier
     */
    @JsonIgnore
    public JsonNullable<String> id() {
        return id;
    }

    /**
     * Provider's unique identifier
     */
    @JsonIgnore
    public JsonNullable<String> remoteId() {
        return remoteId;
    }

    /**
     * The label of the employment type
     */
    @JsonIgnore
    public JsonNullable<String> label() {
        return label;
    }

    /**
     * The type of employment (e.g., contractor, permanent)
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<HrisUpdateEmploymentRequestDtoTypeType> type() {
        return (JsonNullable<HrisUpdateEmploymentRequestDtoTypeType>) type;
    }

    public static Builder builder() {
        return new Builder();
    }


    /**
     * Unique identifier
     */
    public HrisUpdateEmploymentRequestDtoType withId(String id) {
        Utils.checkNotNull(id, "id");
        this.id = JsonNullable.of(id);
        return this;
    }

    /**
     * Unique identifier
     */
    public HrisUpdateEmploymentRequestDtoType withId(JsonNullable<String> id) {
        Utils.checkNotNull(id, "id");
        this.id = id;
        return this;
    }

    /**
     * Provider's unique identifier
     */
    public HrisUpdateEmploymentRequestDtoType withRemoteId(String remoteId) {
        Utils.checkNotNull(remoteId, "remoteId");
        this.remoteId = JsonNullable.of(remoteId);
        return this;
    }

    /**
     * Provider's unique identifier
     */
    public HrisUpdateEmploymentRequestDtoType withRemoteId(JsonNullable<String> remoteId) {
        Utils.checkNotNull(remoteId, "remoteId");
        this.remoteId = remoteId;
        return this;
    }

    /**
     * The label of the employment type
     */
    public HrisUpdateEmploymentRequestDtoType withLabel(String label) {
        Utils.checkNotNull(label, "label");
        this.label = JsonNullable.of(label);
        return this;
    }

    /**
     * The label of the employment type
     */
    public HrisUpdateEmploymentRequestDtoType withLabel(JsonNullable<String> label) {
        Utils.checkNotNull(label, "label");
        this.label = label;
        return this;
    }

    /**
     * The type of employment (e.g., contractor, permanent)
     */
    public HrisUpdateEmploymentRequestDtoType withType(HrisUpdateEmploymentRequestDtoTypeType type) {
        Utils.checkNotNull(type, "type");
        this.type = JsonNullable.of(type);
        return this;
    }

    /**
     * The type of employment (e.g., contractor, permanent)
     */
    public HrisUpdateEmploymentRequestDtoType withType(JsonNullable<? extends HrisUpdateEmploymentRequestDtoTypeType> type) {
        Utils.checkNotNull(type, "type");
        this.type = type;
        return this;
    }

    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        HrisUpdateEmploymentRequestDtoType other = (HrisUpdateEmploymentRequestDtoType) o;
        return 
            Utils.enhancedDeepEquals(this.id, other.id) &&
            Utils.enhancedDeepEquals(this.remoteId, other.remoteId) &&
            Utils.enhancedDeepEquals(this.label, other.label) &&
            Utils.enhancedDeepEquals(this.type, other.type);
    }
    
    @Override
    public int hashCode() {
        return Utils.enhancedHash(
            id, remoteId, label,
            type);
    }
    
    @Override
    public String toString() {
        return Utils.toString(HrisUpdateEmploymentRequestDtoType.class,
                "id", id,
                "remoteId", remoteId,
                "label", label,
                "type", type);
    }

    @SuppressWarnings("UnusedReturnValue")
    public final static class Builder {

        private JsonNullable<String> id = JsonNullable.undefined();

        private JsonNullable<String> remoteId = JsonNullable.undefined();

        private JsonNullable<String> label = JsonNullable.undefined();

        private JsonNullable<? extends HrisUpdateEmploymentRequestDtoTypeType> type = JsonNullable.undefined();

        private Builder() {
          // force use of static builder() method
        }


        /**
         * Unique identifier
         */
        public Builder id(String id) {
            Utils.checkNotNull(id, "id");
            this.id = JsonNullable.of(id);
            return this;
        }

        /**
         * Unique identifier
         */
        public Builder id(JsonNullable<String> id) {
            Utils.checkNotNull(id, "id");
            this.id = id;
            return this;
        }


        /**
         * Provider's unique identifier
         */
        public Builder remoteId(String remoteId) {
            Utils.checkNotNull(remoteId, "remoteId");
            this.remoteId = JsonNullable.of(remoteId);
            return this;
        }

        /**
         * Provider's unique identifier
         */
        public Builder remoteId(JsonNullable<String> remoteId) {
            Utils.checkNotNull(remoteId, "remoteId");
            this.remoteId = remoteId;
            return this;
        }


        /**
         * The label of the employment type
         */
        public Builder label(String label) {
            Utils.checkNotNull(label, "label");
            this.label = JsonNullable.of(label);
            return this;
        }

        /**
         * The label of the employment type
         */
        public Builder label(JsonNullable<String> label) {
            Utils.checkNotNull(label, "label");
            this.label = label;
            return this;
        }


        /**
         * The type of employment (e.g., contractor, permanent)
         */
        public Builder type(HrisUpdateEmploymentRequestDtoTypeType type) {
            Utils.checkNotNull(type, "type");
            this.type = JsonNullable.of(type);
            return this;
        }

        /**
         * The type of employment (e.g., contractor, permanent)
         */
        public Builder type(JsonNullable<? extends HrisUpdateEmploymentRequestDtoTypeType> type) {
            Utils.checkNotNull(type, "type");
            this.type = type;
            return this;
        }

        public HrisUpdateEmploymentRequestDtoType build() {

            return new HrisUpdateEmploymentRequestDtoType(
                id, remoteId, label,
                type);
        }

    }
}
