/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java.models.operations.async;

import static com.stackone.stackone_client_java.operations.Operations.AsyncRequestOperation;
import static com.stackone.stackone_client_java.utils.reactive.ReactiveUtils.mapAsync;

import com.stackone.stackone_client_java.SDKConfiguration;
import com.stackone.stackone_client_java.models.operations.AccountingListCompanyJournalsRequest;
import com.stackone.stackone_client_java.operations.AccountingListCompanyJournals;
import com.stackone.stackone_client_java.utils.Blob;
import com.stackone.stackone_client_java.utils.Headers;
import com.stackone.stackone_client_java.utils.Options;
import com.stackone.stackone_client_java.utils.RetryConfig;
import com.stackone.stackone_client_java.utils.Utils;
import com.stackone.stackone_client_java.utils.pagination.AsyncPaginator;
import com.stackone.stackone_client_java.utils.pagination.CursorTracker;
import java.lang.Exception;
import java.lang.String;
import java.net.http.HttpResponse;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Flow;
import org.reactivestreams.FlowAdapters;
import org.reactivestreams.Publisher;

public class AccountingListCompanyJournalsRequestBuilder {

    private AccountingListCompanyJournalsRequest request;
    private Optional<RetryConfig> retryConfig = Optional.empty();
    private final SDKConfiguration sdkConfiguration;
    private final Headers _headers = new Headers(); 

    public AccountingListCompanyJournalsRequestBuilder(SDKConfiguration sdkConfiguration) {
        this.sdkConfiguration = sdkConfiguration;
    }

    public AccountingListCompanyJournalsRequestBuilder request(AccountingListCompanyJournalsRequest request) {
        Utils.checkNotNull(request, "request");
        this.request = request;
        return this;
    }
                
    public AccountingListCompanyJournalsRequestBuilder retryConfig(RetryConfig retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = Optional.of(retryConfig);
        return this;
    }

    public AccountingListCompanyJournalsRequestBuilder retryConfig(Optional<RetryConfig> retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = retryConfig;
        return this;
    }

    public CompletableFuture<AccountingListCompanyJournalsResponse> call() throws Exception {
        Optional<Options> options = Optional.of(Options.builder()
            .retryConfig(retryConfig)
            .build());

        AsyncRequestOperation<AccountingListCompanyJournalsRequest, AccountingListCompanyJournalsResponse> operation
              = new AccountingListCompanyJournals.Async(
                                    sdkConfiguration, options, sdkConfiguration.retryScheduler(),
                                    _headers);

        return operation.doRequest(request)
            .thenCompose(operation::handleResponse);
    }

    /**
     * Returns a Publisher that performs next page calls till no more pages
     * are returned.
     *
     * <p>The returned publisher can be used with reactive frameworks:
     * <pre><code>
     * Publisher&lt;AccountingListCompanyJournalsResponse&gt; publisher = builder.callAsPublisher();
     * publisher.subscribe(new Subscriber&lt;AccountingListCompanyJournalsResponse&gt;() {
     *     // Handle onNext, onError, onComplete
     * });
     * </code></pre>
     *
     * @return A Publisher that emits pages asynchronously
     */
    public Publisher<AccountingListCompanyJournalsResponse> callAsPublisher() {
        AccountingListCompanyJournalsRequest request = this.request;
        Optional<Options> options = Optional.of(Options.builder()
            .retryConfig(retryConfig)
            .build());

        AsyncRequestOperation<AccountingListCompanyJournalsRequest, AccountingListCompanyJournalsResponse> operation
              = new AccountingListCompanyJournals.Async(
                                    sdkConfiguration, options, sdkConfiguration.retryScheduler(),
                                    _headers);

        Flow.Publisher<HttpResponse<Blob>> asyncPaginator = new AsyncPaginator<>(
            request,
            new CursorTracker<>("$.next", String.class),
                    AccountingListCompanyJournalsRequest::withNext,
            operation::doRequest);

        Flow.Publisher<AccountingListCompanyJournalsResponse> flowPublisher = mapAsync(asyncPaginator, operation::handleResponse);

        // Convert Flow.Publisher to Reactive Streams Publisher at the last stage
        return FlowAdapters.toPublisher(flowPublisher);
    }

}
