/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.stackone.stackone_client_java.utils.Utils;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import org.openapitools.jackson.nullable.JsonNullable;

/**
 * TicketingTicketCreateRequestDtoPriority
 * 
 * <p>Priority of the ticket
 */
public class TicketingTicketCreateRequestDtoPriority {
    /**
     * The id of the ticket priority.
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("id")
    private JsonNullable<String> id;

    /**
     * The priority of the ticket.
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("value")
    private JsonNullable<? extends TicketingTicketCreateRequestDtoValue> value;

    /**
     * The source value of the ticket priority.
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("source_value")
    private JsonNullable<? extends TicketingTicketCreateRequestDtoSourceValue> sourceValue;

    @JsonCreator
    public TicketingTicketCreateRequestDtoPriority(
            @JsonProperty("id") JsonNullable<String> id,
            @JsonProperty("value") JsonNullable<? extends TicketingTicketCreateRequestDtoValue> value,
            @JsonProperty("source_value") JsonNullable<? extends TicketingTicketCreateRequestDtoSourceValue> sourceValue) {
        Utils.checkNotNull(id, "id");
        Utils.checkNotNull(value, "value");
        Utils.checkNotNull(sourceValue, "sourceValue");
        this.id = id;
        this.value = value;
        this.sourceValue = sourceValue;
    }
    
    public TicketingTicketCreateRequestDtoPriority() {
        this(JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined());
    }

    /**
     * The id of the ticket priority.
     */
    @JsonIgnore
    public JsonNullable<String> id() {
        return id;
    }

    /**
     * The priority of the ticket.
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<TicketingTicketCreateRequestDtoValue> value() {
        return (JsonNullable<TicketingTicketCreateRequestDtoValue>) value;
    }

    /**
     * The source value of the ticket priority.
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<TicketingTicketCreateRequestDtoSourceValue> sourceValue() {
        return (JsonNullable<TicketingTicketCreateRequestDtoSourceValue>) sourceValue;
    }

    public static Builder builder() {
        return new Builder();
    }


    /**
     * The id of the ticket priority.
     */
    public TicketingTicketCreateRequestDtoPriority withId(String id) {
        Utils.checkNotNull(id, "id");
        this.id = JsonNullable.of(id);
        return this;
    }

    /**
     * The id of the ticket priority.
     */
    public TicketingTicketCreateRequestDtoPriority withId(JsonNullable<String> id) {
        Utils.checkNotNull(id, "id");
        this.id = id;
        return this;
    }

    /**
     * The priority of the ticket.
     */
    public TicketingTicketCreateRequestDtoPriority withValue(TicketingTicketCreateRequestDtoValue value) {
        Utils.checkNotNull(value, "value");
        this.value = JsonNullable.of(value);
        return this;
    }

    /**
     * The priority of the ticket.
     */
    public TicketingTicketCreateRequestDtoPriority withValue(JsonNullable<? extends TicketingTicketCreateRequestDtoValue> value) {
        Utils.checkNotNull(value, "value");
        this.value = value;
        return this;
    }

    /**
     * The source value of the ticket priority.
     */
    public TicketingTicketCreateRequestDtoPriority withSourceValue(TicketingTicketCreateRequestDtoSourceValue sourceValue) {
        Utils.checkNotNull(sourceValue, "sourceValue");
        this.sourceValue = JsonNullable.of(sourceValue);
        return this;
    }

    /**
     * The source value of the ticket priority.
     */
    public TicketingTicketCreateRequestDtoPriority withSourceValue(JsonNullable<? extends TicketingTicketCreateRequestDtoSourceValue> sourceValue) {
        Utils.checkNotNull(sourceValue, "sourceValue");
        this.sourceValue = sourceValue;
        return this;
    }

    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        TicketingTicketCreateRequestDtoPriority other = (TicketingTicketCreateRequestDtoPriority) o;
        return 
            Utils.enhancedDeepEquals(this.id, other.id) &&
            Utils.enhancedDeepEquals(this.value, other.value) &&
            Utils.enhancedDeepEquals(this.sourceValue, other.sourceValue);
    }
    
    @Override
    public int hashCode() {
        return Utils.enhancedHash(
            id, value, sourceValue);
    }
    
    @Override
    public String toString() {
        return Utils.toString(TicketingTicketCreateRequestDtoPriority.class,
                "id", id,
                "value", value,
                "sourceValue", sourceValue);
    }

    @SuppressWarnings("UnusedReturnValue")
    public final static class Builder {

        private JsonNullable<String> id = JsonNullable.undefined();

        private JsonNullable<? extends TicketingTicketCreateRequestDtoValue> value = JsonNullable.undefined();

        private JsonNullable<? extends TicketingTicketCreateRequestDtoSourceValue> sourceValue = JsonNullable.undefined();

        private Builder() {
          // force use of static builder() method
        }


        /**
         * The id of the ticket priority.
         */
        public Builder id(String id) {
            Utils.checkNotNull(id, "id");
            this.id = JsonNullable.of(id);
            return this;
        }

        /**
         * The id of the ticket priority.
         */
        public Builder id(JsonNullable<String> id) {
            Utils.checkNotNull(id, "id");
            this.id = id;
            return this;
        }


        /**
         * The priority of the ticket.
         */
        public Builder value(TicketingTicketCreateRequestDtoValue value) {
            Utils.checkNotNull(value, "value");
            this.value = JsonNullable.of(value);
            return this;
        }

        /**
         * The priority of the ticket.
         */
        public Builder value(JsonNullable<? extends TicketingTicketCreateRequestDtoValue> value) {
            Utils.checkNotNull(value, "value");
            this.value = value;
            return this;
        }


        /**
         * The source value of the ticket priority.
         */
        public Builder sourceValue(TicketingTicketCreateRequestDtoSourceValue sourceValue) {
            Utils.checkNotNull(sourceValue, "sourceValue");
            this.sourceValue = JsonNullable.of(sourceValue);
            return this;
        }

        /**
         * The source value of the ticket priority.
         */
        public Builder sourceValue(JsonNullable<? extends TicketingTicketCreateRequestDtoSourceValue> sourceValue) {
            Utils.checkNotNull(sourceValue, "sourceValue");
            this.sourceValue = sourceValue;
            return this;
        }

        public TicketingTicketCreateRequestDtoPriority build() {

            return new TicketingTicketCreateRequestDtoPriority(
                id, value, sourceValue);
        }

    }
}
