/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.operations.async;

import com.stackone.stackone_client_java.SDKConfiguration;
import com.stackone.stackone_client_java.models.components.LmsUpsertContentRequestDto;
import com.stackone.stackone_client_java.models.operations.LmsUpsertContentRequest;
import com.stackone.stackone_client_java.models.operations.async.LmsUpsertContentResponse;
import com.stackone.stackone_client_java.operations.LmsUpsertContent;
import com.stackone.stackone_client_java.utils.Headers;
import com.stackone.stackone_client_java.utils.Options;
import com.stackone.stackone_client_java.utils.RetryConfig;
import com.stackone.stackone_client_java.utils.Utils;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;

public class LmsUpsertContentRequestBuilder {
    private String xAccountId;
    private LmsUpsertContentRequestDto lmsUpsertContentRequestDto;
    private Optional<RetryConfig> retryConfig = Optional.empty();
    private final SDKConfiguration sdkConfiguration;
    private final Headers _headers = new Headers();

    public LmsUpsertContentRequestBuilder(SDKConfiguration sdkConfiguration) {
        this.sdkConfiguration = sdkConfiguration;
    }

    public LmsUpsertContentRequestBuilder xAccountId(String xAccountId) {
        Utils.checkNotNull(xAccountId, "xAccountId");
        this.xAccountId = xAccountId;
        return this;
    }

    public LmsUpsertContentRequestBuilder lmsUpsertContentRequestDto(LmsUpsertContentRequestDto lmsUpsertContentRequestDto) {
        Utils.checkNotNull(lmsUpsertContentRequestDto, "lmsUpsertContentRequestDto");
        this.lmsUpsertContentRequestDto = lmsUpsertContentRequestDto;
        return this;
    }

    public LmsUpsertContentRequestBuilder retryConfig(RetryConfig retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = Optional.of(retryConfig);
        return this;
    }

    public LmsUpsertContentRequestBuilder retryConfig(Optional<RetryConfig> retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = retryConfig;
        return this;
    }

    private LmsUpsertContentRequest buildRequest() {
        LmsUpsertContentRequest request = new LmsUpsertContentRequest(this.xAccountId, this.lmsUpsertContentRequestDto);
        return request;
    }

    public CompletableFuture<LmsUpsertContentResponse> call() throws Exception {
        Optional<Options> options = Optional.of(Options.builder().retryConfig(this.retryConfig).build());
        LmsUpsertContent.Async operation = new LmsUpsertContent.Async(this.sdkConfiguration, options, this.sdkConfiguration.retryScheduler(), this._headers);
        LmsUpsertContentRequest request = this.buildRequest();
        return operation.doRequest(request).thenCompose(operation::handleResponse);
    }
}

