/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java.utils;

import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.time.OffsetDateTime;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;

import com.stackone.stackone_client_java.models.errors.AuthException;

import com.fasterxml.jackson.annotation.JsonProperty;

public final class SessionManager<T extends SessionManager.HasSessionKey> {

    // VisibleForTesting
    public static final int REFRESH_BEFORE_EXPIRY_SECONDS = 60;

    private final Map<String, Map<String, Session<T>>> sessions = new HashMap<>();

    public interface HasSessionKey {
        String sessionKey();
    }

    public final static class Session<T> {
        private final T credentials;
        private final Optional<String> token;
        private final List<String> scopes;
        private final Optional<OffsetDateTime> expiresAt;

        public Session(T credentials, Optional<String> token, List<String> scopes, Optional<OffsetDateTime> expiresAt) {
            this.credentials = credentials;
            this.token = token;
            this.scopes = scopes;
            this.expiresAt = expiresAt;
        }

        public T credentials() {
            return credentials;
        }

        public Optional<String> token() {
            return token;
        }

        public List<String> scopes() {
            return scopes;
        }

        public Optional<OffsetDateTime> expiresAt() {
            return expiresAt;
        }

    }

    public Session<T> getSession(T credentials, List<String> scopes, Function<List<String>, Session<T>> tokenProvider ) {
        final String sessionKey = credentials.sessionKey();
        final String scopeKey = getScopeKey(scopes);

        Optional<Session<T>> existingSession = getExistingSession(sessionKey, scopes);
        final Session<T> session;
        if (!existingSession.isPresent()) {
            session = tokenProvider.apply(scopes);
            sessions.computeIfAbsent(sessionKey, k -> new HashMap<>()).put(scopeKey, session);
        } else {
            session = existingSession.get();
        }
        return session;
    }

    private Optional<Session<T>> getExistingSession(String sessionKey, List<String> requiredScopes) {
        Map<String, Session<T>> clientSessions = sessions.get(sessionKey);
        if (clientSessions == null) {
            return Optional.empty();
        }

        String scopeKey = getScopeKey(requiredScopes);

        // First look for an exact match
        Session<T> exactSession = clientSessions.get(scopeKey);
        if (exactSession != null) {
            if (hasTokenExpired(exactSession.expiresAt, OffsetDateTime.now())) {
                removeSession(sessionKey, scopeKey);
            } else {
                return Optional.of(exactSession);
            }
        }

        // If no exact match was found, look for a superset match
        List<String> expiredSessionKeys = new ArrayList<>();
        Session<T> validSession = null;
        for (Map.Entry<String, Session<T>> entry : clientSessions.entrySet()) {
            Session<T> session = entry.getValue();
            if (hasTokenExpired(session.expiresAt, OffsetDateTime.now())) {
                expiredSessionKeys.add(entry.getKey());
            } else if (hasRequiredScopes(session.scopes, requiredScopes)) {
                validSession = session;
            }
        }

        for (String key : expiredSessionKeys) {
            removeSession(sessionKey, key);
        }

        return Optional.ofNullable(validSession);
    }

    private static String getScopeKey(List<String> scopes) {
        if (scopes == null || scopes.isEmpty()) {
            return "";
        }

        List<String> sortedScopes = new ArrayList<>(scopes);
        sortedScopes.sort(String::compareTo);
        return String.join("&", sortedScopes);
    }

    /**
     * Checks if the token has expired.
     * If no expires_in field was returned by the authorization server, the token is considered to never expire.
     * A buffer (REFRESH_BEFORE_EXPIRY_SECONDS) is applied to refresh tokens before they actually expire.
     */
    // VisibleForTesting
    public static boolean hasTokenExpired(Optional<OffsetDateTime> expiresAt, OffsetDateTime now) {
        return !expiresAt.isEmpty() && now.plusSeconds(REFRESH_BEFORE_EXPIRY_SECONDS).isAfter(expiresAt.get());
    }

    // VisibleForTesting
    public static boolean hasRequiredScopes(List<String> sessionScopes, List<String> requiredScopes) {
        return sessionScopes.containsAll(requiredScopes);
    }

    public void remove(String sessionKey) {
        sessions.remove(sessionKey);
    }

    public void removeSession(String sessionKey, String scopeKey) {
        Map<String, Session<T>> clientSessions = sessions.get(sessionKey);
        if (clientSessions != null) {
            clientSessions.remove(scopeKey);
            // Clean up empty client sessions
            if (clientSessions.isEmpty()) {
                sessions.remove(sessionKey);
            }
        }
    }

    public static <T extends HasSessionKey> Session<T> requestOAuth2Token(HTTPClient client, T credentials, List<String> scopes,
            Map<String, String> body, Map<String, String> headers, URI tokenUri) {
        try {
            HttpRequest.Builder requestBuilder = HttpRequest //
                    .newBuilder(tokenUri) //
                    .header("Content-Type", "application/x-www-form-urlencoded") //
                    .POST(RequestBody.serializeFormData(body).body()); //

            for (Map.Entry<String, String> header : headers.entrySet()) {
                requestBuilder.header(header.getKey(), header.getValue());
            }

            HttpRequest request = requestBuilder.build();
            HttpResponse<InputStream> response = client.send(request);
            if (response.statusCode() != HttpURLConnection.HTTP_OK) {
                String responseBody = Utils.toUtf8AndClose(response.body());
                throw new AuthException(
                    "Unexpected status code " + response.statusCode() + ": " + responseBody,
                    response.statusCode(),
                    responseBody.getBytes(StandardCharsets.UTF_8),
                    response);
            }
            TokenResponse t = Utils.mapper().readValue(response.body(), TokenResponse.class);
            if (!t.tokenType.orElse("").toLowerCase().equals("bearer")) {
                throw new AuthException(
                    "Expected 'Bearer' token type but was '" + t.tokenType.orElse("") + "'",
                    response.statusCode(),
                    Utils.readBytesAndClose(response.body()),
                    response);
            }
            final Optional<OffsetDateTime> expiresAt = t.expiresInSeconds
                    .map(x -> OffsetDateTime.now().plus(x, ChronoUnit.SECONDS));
            return new Session<T>(credentials, t.accessToken, scopes, expiresAt);
        } catch (IOException | IllegalArgumentException | IllegalAccessException | InterruptedException | URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    final static class TokenResponse {

        @JsonProperty("access_token")
        Optional<String> accessToken;

        @JsonProperty("token_type")
        Optional<String> tokenType;

        @JsonProperty("expires_in")
        Optional<Long> expiresInSeconds;;

    }

}
