/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.stackone.stackone_client_java.utils.Utils;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Map;
import org.openapitools.jackson.nullable.JsonNullable;


public class ScreeningCreateOrderRequestDto {
    /**
     * Value to pass through to the provider
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("passthrough")
    private JsonNullable<? extends Map<String, Object>> passthrough;

    /**
     * Custom Unified Fields configured in your StackOne project
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("unified_custom_fields")
    private JsonNullable<? extends Map<String, Object>> unifiedCustomFields;

    /**
     * Package ID
     */
    @JsonProperty("package_id")
    private String packageId;

    /**
     * Candidate information
     */
    @JsonProperty("candidate")
    private ScreeningOrderCandidate candidate;

    @JsonCreator
    public ScreeningCreateOrderRequestDto(
            @JsonProperty("passthrough") JsonNullable<? extends Map<String, Object>> passthrough,
            @JsonProperty("unified_custom_fields") JsonNullable<? extends Map<String, Object>> unifiedCustomFields,
            @JsonProperty("package_id") String packageId,
            @JsonProperty("candidate") ScreeningOrderCandidate candidate) {
        Utils.checkNotNull(passthrough, "passthrough");
        Utils.checkNotNull(unifiedCustomFields, "unifiedCustomFields");
        Utils.checkNotNull(packageId, "packageId");
        Utils.checkNotNull(candidate, "candidate");
        this.passthrough = passthrough;
        this.unifiedCustomFields = unifiedCustomFields;
        this.packageId = packageId;
        this.candidate = candidate;
    }
    
    public ScreeningCreateOrderRequestDto(
            String packageId,
            ScreeningOrderCandidate candidate) {
        this(JsonNullable.undefined(), JsonNullable.undefined(), packageId,
            candidate);
    }

    /**
     * Value to pass through to the provider
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<Map<String, Object>> passthrough() {
        return (JsonNullable<Map<String, Object>>) passthrough;
    }

    /**
     * Custom Unified Fields configured in your StackOne project
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<Map<String, Object>> unifiedCustomFields() {
        return (JsonNullable<Map<String, Object>>) unifiedCustomFields;
    }

    /**
     * Package ID
     */
    @JsonIgnore
    public String packageId() {
        return packageId;
    }

    /**
     * Candidate information
     */
    @JsonIgnore
    public ScreeningOrderCandidate candidate() {
        return candidate;
    }

    public static Builder builder() {
        return new Builder();
    }


    /**
     * Value to pass through to the provider
     */
    public ScreeningCreateOrderRequestDto withPassthrough(Map<String, Object> passthrough) {
        Utils.checkNotNull(passthrough, "passthrough");
        this.passthrough = JsonNullable.of(passthrough);
        return this;
    }

    /**
     * Value to pass through to the provider
     */
    public ScreeningCreateOrderRequestDto withPassthrough(JsonNullable<? extends Map<String, Object>> passthrough) {
        Utils.checkNotNull(passthrough, "passthrough");
        this.passthrough = passthrough;
        return this;
    }

    /**
     * Custom Unified Fields configured in your StackOne project
     */
    public ScreeningCreateOrderRequestDto withUnifiedCustomFields(Map<String, Object> unifiedCustomFields) {
        Utils.checkNotNull(unifiedCustomFields, "unifiedCustomFields");
        this.unifiedCustomFields = JsonNullable.of(unifiedCustomFields);
        return this;
    }

    /**
     * Custom Unified Fields configured in your StackOne project
     */
    public ScreeningCreateOrderRequestDto withUnifiedCustomFields(JsonNullable<? extends Map<String, Object>> unifiedCustomFields) {
        Utils.checkNotNull(unifiedCustomFields, "unifiedCustomFields");
        this.unifiedCustomFields = unifiedCustomFields;
        return this;
    }

    /**
     * Package ID
     */
    public ScreeningCreateOrderRequestDto withPackageId(String packageId) {
        Utils.checkNotNull(packageId, "packageId");
        this.packageId = packageId;
        return this;
    }

    /**
     * Candidate information
     */
    public ScreeningCreateOrderRequestDto withCandidate(ScreeningOrderCandidate candidate) {
        Utils.checkNotNull(candidate, "candidate");
        this.candidate = candidate;
        return this;
    }

    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        ScreeningCreateOrderRequestDto other = (ScreeningCreateOrderRequestDto) o;
        return 
            Utils.enhancedDeepEquals(this.passthrough, other.passthrough) &&
            Utils.enhancedDeepEquals(this.unifiedCustomFields, other.unifiedCustomFields) &&
            Utils.enhancedDeepEquals(this.packageId, other.packageId) &&
            Utils.enhancedDeepEquals(this.candidate, other.candidate);
    }
    
    @Override
    public int hashCode() {
        return Utils.enhancedHash(
            passthrough, unifiedCustomFields, packageId,
            candidate);
    }
    
    @Override
    public String toString() {
        return Utils.toString(ScreeningCreateOrderRequestDto.class,
                "passthrough", passthrough,
                "unifiedCustomFields", unifiedCustomFields,
                "packageId", packageId,
                "candidate", candidate);
    }

    @SuppressWarnings("UnusedReturnValue")
    public final static class Builder {

        private JsonNullable<? extends Map<String, Object>> passthrough = JsonNullable.undefined();

        private JsonNullable<? extends Map<String, Object>> unifiedCustomFields = JsonNullable.undefined();

        private String packageId;

        private ScreeningOrderCandidate candidate;

        private Builder() {
          // force use of static builder() method
        }


        /**
         * Value to pass through to the provider
         */
        public Builder passthrough(Map<String, Object> passthrough) {
            Utils.checkNotNull(passthrough, "passthrough");
            this.passthrough = JsonNullable.of(passthrough);
            return this;
        }

        /**
         * Value to pass through to the provider
         */
        public Builder passthrough(JsonNullable<? extends Map<String, Object>> passthrough) {
            Utils.checkNotNull(passthrough, "passthrough");
            this.passthrough = passthrough;
            return this;
        }


        /**
         * Custom Unified Fields configured in your StackOne project
         */
        public Builder unifiedCustomFields(Map<String, Object> unifiedCustomFields) {
            Utils.checkNotNull(unifiedCustomFields, "unifiedCustomFields");
            this.unifiedCustomFields = JsonNullable.of(unifiedCustomFields);
            return this;
        }

        /**
         * Custom Unified Fields configured in your StackOne project
         */
        public Builder unifiedCustomFields(JsonNullable<? extends Map<String, Object>> unifiedCustomFields) {
            Utils.checkNotNull(unifiedCustomFields, "unifiedCustomFields");
            this.unifiedCustomFields = unifiedCustomFields;
            return this;
        }


        /**
         * Package ID
         */
        public Builder packageId(String packageId) {
            Utils.checkNotNull(packageId, "packageId");
            this.packageId = packageId;
            return this;
        }


        /**
         * Candidate information
         */
        public Builder candidate(ScreeningOrderCandidate candidate) {
            Utils.checkNotNull(candidate, "candidate");
            this.candidate = candidate;
            return this;
        }

        public ScreeningCreateOrderRequestDto build() {

            return new ScreeningCreateOrderRequestDto(
                passthrough, unifiedCustomFields, packageId,
                candidate);
        }

    }
}
