/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java.models.operations;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.stackone.stackone_client_java.utils.SpeakeasyMetadata;
import com.stackone.stackone_client_java.utils.Utils;
import java.lang.Override;
import java.lang.String;
import java.time.OffsetDateTime;
import org.openapitools.jackson.nullable.JsonNullable;

/**
 * AtsListCandidatesQueryParamFilter
 * 
 * <p>ATS Candidate Filter
 */
public class AtsListCandidatesQueryParamFilter {
    /**
     * Use a string with a date to only select results updated after that given date
     */
    @SpeakeasyMetadata("queryParam:name=updated_after")
    private JsonNullable<OffsetDateTime> updatedAfter;

    /**
     * Use a string with a date to only select results created after that given date
     */
    @SpeakeasyMetadata("queryParam:name=created_after")
    private JsonNullable<OffsetDateTime> createdAfter;

    /**
     * Filter to select candidates by email
     */
    @SpeakeasyMetadata("queryParam:name=email")
    private JsonNullable<String> email;

    @JsonCreator
    public AtsListCandidatesQueryParamFilter(
            JsonNullable<OffsetDateTime> updatedAfter,
            JsonNullable<OffsetDateTime> createdAfter,
            JsonNullable<String> email) {
        Utils.checkNotNull(updatedAfter, "updatedAfter");
        Utils.checkNotNull(createdAfter, "createdAfter");
        Utils.checkNotNull(email, "email");
        this.updatedAfter = updatedAfter;
        this.createdAfter = createdAfter;
        this.email = email;
    }
    
    public AtsListCandidatesQueryParamFilter() {
        this(JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined());
    }

    /**
     * Use a string with a date to only select results updated after that given date
     */
    @JsonIgnore
    public JsonNullable<OffsetDateTime> updatedAfter() {
        return updatedAfter;
    }

    /**
     * Use a string with a date to only select results created after that given date
     */
    @JsonIgnore
    public JsonNullable<OffsetDateTime> createdAfter() {
        return createdAfter;
    }

    /**
     * Filter to select candidates by email
     */
    @JsonIgnore
    public JsonNullable<String> email() {
        return email;
    }

    public static Builder builder() {
        return new Builder();
    }


    /**
     * Use a string with a date to only select results updated after that given date
     */
    public AtsListCandidatesQueryParamFilter withUpdatedAfter(OffsetDateTime updatedAfter) {
        Utils.checkNotNull(updatedAfter, "updatedAfter");
        this.updatedAfter = JsonNullable.of(updatedAfter);
        return this;
    }

    /**
     * Use a string with a date to only select results updated after that given date
     */
    public AtsListCandidatesQueryParamFilter withUpdatedAfter(JsonNullable<OffsetDateTime> updatedAfter) {
        Utils.checkNotNull(updatedAfter, "updatedAfter");
        this.updatedAfter = updatedAfter;
        return this;
    }

    /**
     * Use a string with a date to only select results created after that given date
     */
    public AtsListCandidatesQueryParamFilter withCreatedAfter(OffsetDateTime createdAfter) {
        Utils.checkNotNull(createdAfter, "createdAfter");
        this.createdAfter = JsonNullable.of(createdAfter);
        return this;
    }

    /**
     * Use a string with a date to only select results created after that given date
     */
    public AtsListCandidatesQueryParamFilter withCreatedAfter(JsonNullable<OffsetDateTime> createdAfter) {
        Utils.checkNotNull(createdAfter, "createdAfter");
        this.createdAfter = createdAfter;
        return this;
    }

    /**
     * Filter to select candidates by email
     */
    public AtsListCandidatesQueryParamFilter withEmail(String email) {
        Utils.checkNotNull(email, "email");
        this.email = JsonNullable.of(email);
        return this;
    }

    /**
     * Filter to select candidates by email
     */
    public AtsListCandidatesQueryParamFilter withEmail(JsonNullable<String> email) {
        Utils.checkNotNull(email, "email");
        this.email = email;
        return this;
    }

    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        AtsListCandidatesQueryParamFilter other = (AtsListCandidatesQueryParamFilter) o;
        return 
            Utils.enhancedDeepEquals(this.updatedAfter, other.updatedAfter) &&
            Utils.enhancedDeepEquals(this.createdAfter, other.createdAfter) &&
            Utils.enhancedDeepEquals(this.email, other.email);
    }
    
    @Override
    public int hashCode() {
        return Utils.enhancedHash(
            updatedAfter, createdAfter, email);
    }
    
    @Override
    public String toString() {
        return Utils.toString(AtsListCandidatesQueryParamFilter.class,
                "updatedAfter", updatedAfter,
                "createdAfter", createdAfter,
                "email", email);
    }

    @SuppressWarnings("UnusedReturnValue")
    public final static class Builder {

        private JsonNullable<OffsetDateTime> updatedAfter = JsonNullable.undefined();

        private JsonNullable<OffsetDateTime> createdAfter = JsonNullable.undefined();

        private JsonNullable<String> email = JsonNullable.undefined();

        private Builder() {
          // force use of static builder() method
        }


        /**
         * Use a string with a date to only select results updated after that given date
         */
        public Builder updatedAfter(OffsetDateTime updatedAfter) {
            Utils.checkNotNull(updatedAfter, "updatedAfter");
            this.updatedAfter = JsonNullable.of(updatedAfter);
            return this;
        }

        /**
         * Use a string with a date to only select results updated after that given date
         */
        public Builder updatedAfter(JsonNullable<OffsetDateTime> updatedAfter) {
            Utils.checkNotNull(updatedAfter, "updatedAfter");
            this.updatedAfter = updatedAfter;
            return this;
        }


        /**
         * Use a string with a date to only select results created after that given date
         */
        public Builder createdAfter(OffsetDateTime createdAfter) {
            Utils.checkNotNull(createdAfter, "createdAfter");
            this.createdAfter = JsonNullable.of(createdAfter);
            return this;
        }

        /**
         * Use a string with a date to only select results created after that given date
         */
        public Builder createdAfter(JsonNullable<OffsetDateTime> createdAfter) {
            Utils.checkNotNull(createdAfter, "createdAfter");
            this.createdAfter = createdAfter;
            return this;
        }


        /**
         * Filter to select candidates by email
         */
        public Builder email(String email) {
            Utils.checkNotNull(email, "email");
            this.email = JsonNullable.of(email);
            return this;
        }

        /**
         * Filter to select candidates by email
         */
        public Builder email(JsonNullable<String> email) {
            Utils.checkNotNull(email, "email");
            this.email = email;
            return this;
        }

        public AtsListCandidatesQueryParamFilter build() {

            return new AtsListCandidatesQueryParamFilter(
                updatedAfter, createdAfter, email);
        }

    }
}
