/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java.models.operations.async;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.stackone.stackone_client_java.models.components.AccountingCompanyResult;
import com.stackone.stackone_client_java.utils.AsyncResponse;
import com.stackone.stackone_client_java.utils.Blob;
import com.stackone.stackone_client_java.utils.Utils;
import java.lang.Integer;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.net.http.HttpResponse;
import java.util.List;
import java.util.Map;
import java.util.Optional;


public class AccountingGetCompanyResponse implements AsyncResponse {
    /**
     * HTTP response content type for this operation
     */
    private String contentType;

    /**
     * HTTP response status code for this operation
     */
    private int statusCode;

    /**
     * Raw HTTP response; suitable for custom response parsing
     */
    private HttpResponse<Blob> rawResponse;

    /**
     * The company with the given identifier was retrieved.
     */
    private Optional<? extends AccountingCompanyResult> accountingCompanyResult;


    private Map<String, List<String>> headers;

    @JsonCreator
    public AccountingGetCompanyResponse(
            String contentType,
            int statusCode,
            HttpResponse<Blob> rawResponse,
            Optional<? extends AccountingCompanyResult> accountingCompanyResult,
            Map<String, List<String>> headers) {
        Utils.checkNotNull(contentType, "contentType");
        Utils.checkNotNull(statusCode, "statusCode");
        Utils.checkNotNull(rawResponse, "rawResponse");
        Utils.checkNotNull(accountingCompanyResult, "accountingCompanyResult");
        headers = Utils.emptyMapIfNull(headers);
        Utils.checkNotNull(headers, "headers");
        this.contentType = contentType;
        this.statusCode = statusCode;
        this.rawResponse = rawResponse;
        this.accountingCompanyResult = accountingCompanyResult;
        this.headers = headers;
    }
    
    public AccountingGetCompanyResponse(
            String contentType,
            int statusCode,
            HttpResponse<Blob> rawResponse,
            Map<String, List<String>> headers) {
        this(contentType, statusCode, rawResponse,
            Optional.empty(), headers);
    }

    /**
     * HTTP response content type for this operation
     */
    @JsonIgnore
    public String contentType() {
        return contentType;
    }

    /**
     * HTTP response status code for this operation
     */
    @JsonIgnore
    public int statusCode() {
        return statusCode;
    }

    /**
     * Raw HTTP response; suitable for custom response parsing
     */
    @JsonIgnore
    public HttpResponse<Blob> rawResponse() {
        return rawResponse;
    }

    /**
     * The company with the given identifier was retrieved.
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public Optional<AccountingCompanyResult> accountingCompanyResult() {
        return (Optional<AccountingCompanyResult>) accountingCompanyResult;
    }

    @JsonIgnore
    public Map<String, List<String>> headers() {
        return headers;
    }

    public static Builder builder() {
        return new Builder();
    }


    /**
     * HTTP response content type for this operation
     */
    public AccountingGetCompanyResponse withContentType(String contentType) {
        Utils.checkNotNull(contentType, "contentType");
        this.contentType = contentType;
        return this;
    }

    /**
     * HTTP response status code for this operation
     */
    public AccountingGetCompanyResponse withStatusCode(int statusCode) {
        Utils.checkNotNull(statusCode, "statusCode");
        this.statusCode = statusCode;
        return this;
    }

    /**
     * Raw HTTP response; suitable for custom response parsing
     */
    public AccountingGetCompanyResponse withRawResponse(HttpResponse<Blob> rawResponse) {
        Utils.checkNotNull(rawResponse, "rawResponse");
        this.rawResponse = rawResponse;
        return this;
    }

    /**
     * The company with the given identifier was retrieved.
     */
    public AccountingGetCompanyResponse withAccountingCompanyResult(AccountingCompanyResult accountingCompanyResult) {
        Utils.checkNotNull(accountingCompanyResult, "accountingCompanyResult");
        this.accountingCompanyResult = Optional.ofNullable(accountingCompanyResult);
        return this;
    }


    /**
     * The company with the given identifier was retrieved.
     */
    public AccountingGetCompanyResponse withAccountingCompanyResult(Optional<? extends AccountingCompanyResult> accountingCompanyResult) {
        Utils.checkNotNull(accountingCompanyResult, "accountingCompanyResult");
        this.accountingCompanyResult = accountingCompanyResult;
        return this;
    }

    public AccountingGetCompanyResponse withHeaders(Map<String, List<String>> headers) {
        Utils.checkNotNull(headers, "headers");
        this.headers = headers;
        return this;
    }

    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        AccountingGetCompanyResponse other = (AccountingGetCompanyResponse) o;
        return 
            Utils.enhancedDeepEquals(this.contentType, other.contentType) &&
            Utils.enhancedDeepEquals(this.statusCode, other.statusCode) &&
            Utils.enhancedDeepEquals(this.rawResponse, other.rawResponse) &&
            Utils.enhancedDeepEquals(this.accountingCompanyResult, other.accountingCompanyResult) &&
            Utils.enhancedDeepEquals(this.headers, other.headers);
    }
    
    @Override
    public int hashCode() {
        return Utils.enhancedHash(
            contentType, statusCode, rawResponse,
            accountingCompanyResult, headers);
    }
    
    @Override
    public String toString() {
        return Utils.toString(AccountingGetCompanyResponse.class,
                "contentType", contentType,
                "statusCode", statusCode,
                "rawResponse", rawResponse,
                "accountingCompanyResult", accountingCompanyResult,
                "headers", headers);
    }

    @SuppressWarnings("UnusedReturnValue")
    public final static class Builder {

        private String contentType;

        private Integer statusCode;

        private HttpResponse<Blob> rawResponse;

        private Optional<? extends AccountingCompanyResult> accountingCompanyResult = Optional.empty();

        private Map<String, List<String>> headers;

        private Builder() {
          // force use of static builder() method
        }


        /**
         * HTTP response content type for this operation
         */
        public Builder contentType(String contentType) {
            Utils.checkNotNull(contentType, "contentType");
            this.contentType = contentType;
            return this;
        }


        /**
         * HTTP response status code for this operation
         */
        public Builder statusCode(int statusCode) {
            Utils.checkNotNull(statusCode, "statusCode");
            this.statusCode = statusCode;
            return this;
        }


        /**
         * Raw HTTP response; suitable for custom response parsing
         */
        public Builder rawResponse(HttpResponse<Blob> rawResponse) {
            Utils.checkNotNull(rawResponse, "rawResponse");
            this.rawResponse = rawResponse;
            return this;
        }


        /**
         * The company with the given identifier was retrieved.
         */
        public Builder accountingCompanyResult(AccountingCompanyResult accountingCompanyResult) {
            Utils.checkNotNull(accountingCompanyResult, "accountingCompanyResult");
            this.accountingCompanyResult = Optional.ofNullable(accountingCompanyResult);
            return this;
        }

        /**
         * The company with the given identifier was retrieved.
         */
        public Builder accountingCompanyResult(Optional<? extends AccountingCompanyResult> accountingCompanyResult) {
            Utils.checkNotNull(accountingCompanyResult, "accountingCompanyResult");
            this.accountingCompanyResult = accountingCompanyResult;
            return this;
        }


        public Builder headers(Map<String, List<String>> headers) {
            Utils.checkNotNull(headers, "headers");
            this.headers = headers;
            return this;
        }

        public AccountingGetCompanyResponse build() {

            return new AccountingGetCompanyResponse(
                contentType, statusCode, rawResponse,
                accountingCompanyResult, headers);
        }

    }
}
