/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java;

import com.stackone.stackone_client_java.SecuritySource;
import com.stackone.stackone_client_java.utils.AsyncHooks;
import com.stackone.stackone_client_java.utils.HTTPClient;
import com.stackone.stackone_client_java.utils.Hooks;
import com.stackone.stackone_client_java.utils.RetryConfig;
import com.stackone.stackone_client_java.utils.SpeakeasyHTTPClient;
import com.stackone.stackone_client_java.utils.Utils;
import java.util.Optional;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;

public class SDKConfiguration {
    private static final String LANGUAGE = "java";
    public static final String OPENAPI_DOC_VERSION = "1.0.0";
    public static final String SDK_VERSION = "0.16.0";
    public static final String GEN_VERSION = "2.737.0";
    private static final String BASE_PACKAGE = "com.stackone.stackone_client_java";
    public static final String USER_AGENT = String.format("speakeasy-sdk/%s %s %s %s %s", "java", "0.16.0", "2.737.0", "1.0.0", "com.stackone.stackone_client_java");
    private SecuritySource securitySource = SecuritySource.of(null);
    private HTTPClient client = new SpeakeasyHTTPClient();
    private String serverUrl;
    private int serverIdx = 0;
    private Hooks _hooks = SDKConfiguration.createHooks();
    private Optional<RetryConfig> retryConfig = Optional.empty();
    private ScheduledExecutorService retryScheduler = Executors.newSingleThreadScheduledExecutor();
    private AsyncHooks _asyncHooks = new AsyncHooks();

    public SecuritySource securitySource() {
        return this.securitySource;
    }

    public void setSecuritySource(SecuritySource securitySource) {
        Utils.checkNotNull(securitySource, "securitySource");
        this.securitySource = securitySource;
    }

    public HTTPClient client() {
        return this.client;
    }

    public void setClient(HTTPClient client) {
        Utils.checkNotNull(client, "client");
        this.client = client;
    }

    public String serverUrl() {
        return this.serverUrl;
    }

    public void setServerUrl(String serverUrl) {
        Utils.checkNotNull(serverUrl, "serverUrl");
        this.serverUrl = SDKConfiguration.trimFinalSlash(serverUrl);
    }

    private static String trimFinalSlash(String url) {
        if (url == null) {
            return null;
        }
        if (url.endsWith("/")) {
            return url.substring(0, url.length() - 1);
        }
        return url;
    }

    public String resolvedServerUrl() {
        return this.serverUrl;
    }

    public void setServerIdx(int serverIdx) {
        this.serverIdx = serverIdx;
    }

    public int serverIdx() {
        return this.serverIdx;
    }

    private static Hooks createHooks() {
        Hooks hooks = new Hooks();
        return hooks;
    }

    public Hooks hooks() {
        return this._hooks;
    }

    public void setHooks(Hooks hooks) {
        this._hooks = hooks;
    }

    public void initialize() {
    }

    public Optional<RetryConfig> retryConfig() {
        return this.retryConfig;
    }

    public void setRetryConfig(Optional<RetryConfig> retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = retryConfig;
    }

    public ScheduledExecutorService retryScheduler() {
        return this.retryScheduler;
    }

    public void setAsyncRetryScheduler(ScheduledExecutorService retryScheduler) {
        Utils.checkNotNull(retryScheduler, "retryScheduler");
        this.retryScheduler = retryScheduler;
    }

    public AsyncHooks asyncHooks() {
        return this._asyncHooks;
    }

    public void setAsyncHooks(AsyncHooks asyncHooks) {
        Utils.checkNotNull(asyncHooks, "asyncHooks");
        this._asyncHooks = asyncHooks;
    }
}

