/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.core.JacksonException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonDeserialize(using=_Deserializer.class)
@JsonSerialize(using=_Serializer.class)
public class IamPermissionValue {
    public static final IamPermissionValue READ = new IamPermissionValue("read");
    public static final IamPermissionValue READ_WRITE = new IamPermissionValue("read_write");
    public static final IamPermissionValue APPROVE = new IamPermissionValue("approve");
    public static final IamPermissionValue DELETE = new IamPermissionValue("delete");
    public static final IamPermissionValue USE = new IamPermissionValue("use");
    public static final IamPermissionValue EXPORT = new IamPermissionValue("export");
    public static final IamPermissionValue UNMAPPED_VALUE = new IamPermissionValue("unmapped_value");
    private static final Map<String, IamPermissionValue> values = IamPermissionValue.createValuesMap();
    private static final Map<String, IamPermissionValueEnum> enums = IamPermissionValue.createEnumsMap();
    private final String value;

    private IamPermissionValue(String value) {
        this.value = value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IamPermissionValue of(String value) {
        Class<IamPermissionValue> clazz = IamPermissionValue.class;
        synchronized (IamPermissionValue.class) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return values.computeIfAbsent(value, v -> new IamPermissionValue((String)v));
        }
    }

    public String value() {
        return this.value;
    }

    public Optional<IamPermissionValueEnum> asEnum() {
        return Optional.ofNullable(enums.getOrDefault(this.value, null));
    }

    public boolean isKnown() {
        return this.asEnum().isPresent();
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        IamPermissionValue other = (IamPermissionValue)obj;
        return Objects.equals(this.value, other.value);
    }

    public String toString() {
        return "IamPermissionValue [value=" + this.value + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IamPermissionValue[] values() {
        Class<IamPermissionValue> clazz = IamPermissionValue.class;
        synchronized (IamPermissionValue.class) {
            // ** MonitorExit[var0] (shouldn't be in output)
            return values.values().toArray(new IamPermissionValue[0]);
        }
    }

    private static final Map<String, IamPermissionValue> createValuesMap() {
        LinkedHashMap<String, IamPermissionValue> map = new LinkedHashMap<String, IamPermissionValue>();
        map.put("read", READ);
        map.put("read_write", READ_WRITE);
        map.put("approve", APPROVE);
        map.put("delete", DELETE);
        map.put("use", USE);
        map.put("export", EXPORT);
        map.put("unmapped_value", UNMAPPED_VALUE);
        return map;
    }

    private static final Map<String, IamPermissionValueEnum> createEnumsMap() {
        HashMap<String, IamPermissionValueEnum> map = new HashMap<String, IamPermissionValueEnum>();
        map.put("read", IamPermissionValueEnum.READ);
        map.put("read_write", IamPermissionValueEnum.READ_WRITE);
        map.put("approve", IamPermissionValueEnum.APPROVE);
        map.put("delete", IamPermissionValueEnum.DELETE);
        map.put("use", IamPermissionValueEnum.USE);
        map.put("export", IamPermissionValueEnum.EXPORT);
        map.put("unmapped_value", IamPermissionValueEnum.UNMAPPED_VALUE);
        return map;
    }

    public static enum IamPermissionValueEnum {
        READ("read"),
        READ_WRITE("read_write"),
        APPROVE("approve"),
        DELETE("delete"),
        USE("use"),
        EXPORT("export"),
        UNMAPPED_VALUE("unmapped_value");

        private final String value;

        private IamPermissionValueEnum(String value) {
            this.value = value;
        }

        public String value() {
            return this.value;
        }
    }

    public static final class _Deserializer
    extends StdDeserializer<IamPermissionValue> {
        protected _Deserializer() {
            super(IamPermissionValue.class);
        }

        public IamPermissionValue deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JacksonException {
            String v = (String)p.readValueAs((TypeReference)new TypeReference<String>(){});
            return IamPermissionValue.of(v);
        }
    }

    public static final class _Serializer
    extends StdSerializer<IamPermissionValue> {
        protected _Serializer() {
            super(IamPermissionValue.class);
        }

        public void serialize(IamPermissionValue value, JsonGenerator g, SerializerProvider provider) throws IOException, JsonProcessingException {
            g.writeObject((Object)value.value);
        }
    }
}

