/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.core.JacksonException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

/**
 * <p>Wrapper class for an "open" enum. "Open" enums are those that are expected
 * to evolve (particularly with the addition of enum members over time). If an
 * open enum is used then the appearance of unexpected enum values (say in a 
 * response from an updated an API) will not bring about a runtime error thus 
 * ensuring that non-updated client versions can continue to work without error.
 *
 * <p>Note that instances are immutable and are singletons (an internal thread-safe
 * cache is maintained to ensure that). As a consequence instances created with the 
 * same value will satisfy reference equality (via {@code ==}).
 * 
 * <p>This class is intended to emulate an enum (in terms of common usage and with 
 * reference equality) but with the ability to carry unknown values. Unfortunately
 * Java does not permit the use of an instance in a switch expression but you can 
 * use the {@code asEnum()} method (after dealing with the `Optional` appropriately).
 *
 */
/**
 * AccountingAccountValue
 * 
 * <p>Type of account
 */
@JsonDeserialize(using = AccountingAccountValue._Deserializer.class)
@JsonSerialize(using = AccountingAccountValue._Serializer.class)
public class AccountingAccountValue {

    public static final AccountingAccountValue ASSET = new AccountingAccountValue("asset");
    public static final AccountingAccountValue LIABILITY = new AccountingAccountValue("liability");
    public static final AccountingAccountValue EQUITY = new AccountingAccountValue("equity");
    public static final AccountingAccountValue REVENUE = new AccountingAccountValue("revenue");
    public static final AccountingAccountValue EXPENSE = new AccountingAccountValue("expense");
    public static final AccountingAccountValue UNMAPPED_VALUE = new AccountingAccountValue("unmapped_value");

    // This map will grow whenever a Color gets created with a new
    // unrecognized value (a potential memory leak if the user is not
    // careful). Keep this field lower case to avoid clashing with
    // generated member names which will always be upper cased (Java
    // convention)
    private static final Map<String, AccountingAccountValue> values = createValuesMap();
    private static final Map<String, AccountingAccountValueEnum> enums = createEnumsMap();

    private final String value;

    private AccountingAccountValue(String value) {
        this.value = value;
    }

    /**
     * Returns a AccountingAccountValue with the given value. For a specific value the 
     * returned object will always be a singleton so reference equality 
     * is satisfied when the values are the same.
     * 
     * @param value value to be wrapped as AccountingAccountValue
     */ 
    public static AccountingAccountValue of(String value) {
        synchronized (AccountingAccountValue.class) {
            return values.computeIfAbsent(value, v -> new AccountingAccountValue(v));
        }
    }

    public String value() {
        return value;
    }

    public Optional<AccountingAccountValueEnum> asEnum() {
        return Optional.ofNullable(enums.getOrDefault(value, null));
    }

    public boolean isKnown() {
        return asEnum().isPresent();
    }

    @Override
    public int hashCode() {
        return Objects.hash(value);
    }

    @Override
    public boolean equals(java.lang.Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;
        if (getClass() != obj.getClass())
            return false;
        AccountingAccountValue other = (AccountingAccountValue) obj;
        return Objects.equals(value, other.value);
    }

    @Override
    public String toString() {
        return "AccountingAccountValue [value=" + value + "]";
    }

    // return an array just like an enum
    public static AccountingAccountValue[] values() {
        synchronized (AccountingAccountValue.class) {
            return values.values().toArray(new AccountingAccountValue[] {});
        }
    }

    private static final Map<String, AccountingAccountValue> createValuesMap() {
        Map<String, AccountingAccountValue> map = new LinkedHashMap<>();
        map.put("asset", ASSET);
        map.put("liability", LIABILITY);
        map.put("equity", EQUITY);
        map.put("revenue", REVENUE);
        map.put("expense", EXPENSE);
        map.put("unmapped_value", UNMAPPED_VALUE);
        return map;
    }

    private static final Map<String, AccountingAccountValueEnum> createEnumsMap() {
        Map<String, AccountingAccountValueEnum> map = new HashMap<>();
        map.put("asset", AccountingAccountValueEnum.ASSET);
        map.put("liability", AccountingAccountValueEnum.LIABILITY);
        map.put("equity", AccountingAccountValueEnum.EQUITY);
        map.put("revenue", AccountingAccountValueEnum.REVENUE);
        map.put("expense", AccountingAccountValueEnum.EXPENSE);
        map.put("unmapped_value", AccountingAccountValueEnum.UNMAPPED_VALUE);
        return map;
    }
    
    @SuppressWarnings("serial")
    public static final class _Serializer extends StdSerializer<AccountingAccountValue> {

        protected _Serializer() {
            super(AccountingAccountValue.class);
        }

        @Override
        public void serialize(AccountingAccountValue value, JsonGenerator g, SerializerProvider provider)
                throws IOException, JsonProcessingException {
            g.writeObject(value.value);
        }
    }

    @SuppressWarnings("serial")
    public static final class _Deserializer extends StdDeserializer<AccountingAccountValue> {

        protected _Deserializer() {
            super(AccountingAccountValue.class);
        }

        @Override
        public AccountingAccountValue deserialize(JsonParser p, DeserializationContext ctxt)
                throws IOException, JacksonException {
            String v = p.readValueAs(new TypeReference<String>() {});
            // use the factory method to ensure we get singletons
            return AccountingAccountValue.of(v);
        }
    }
    
    public enum AccountingAccountValueEnum {

        ASSET("asset"),
        LIABILITY("liability"),
        EQUITY("equity"),
        REVENUE("revenue"),
        EXPENSE("expense"),
        UNMAPPED_VALUE("unmapped_value"),;

        private final String value;

        private AccountingAccountValueEnum(String value) {
            this.value = value;
        }

        public String value() {
            return value;
        }
    }
}

