/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java.models.operations;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.stackone.stackone_client_java.models.components.DownloadApiModel;
import com.stackone.stackone_client_java.utils.Response;
import com.stackone.stackone_client_java.utils.Utils;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.lang.Integer;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.net.http.HttpResponse;
import java.util.List;
import java.util.Map;
import java.util.Optional;


public class AtsDownloadApplicationDocumentResponse implements Response {
    /**
     * HTTP response content type for this operation
     */
    private String contentType;

    /**
     * HTTP response status code for this operation
     */
    private int statusCode;

    /**
     * Raw HTTP response; suitable for custom response parsing
     */
    private HttpResponse<InputStream> rawResponse;


    private Optional<byte[]> body;

    /**
     * The document related to the application with the given identifiers was retrieved.
     */
    private Optional<String> downloadApiModel;

    /**
     * The document related to the application with the given identifiers was retrieved.
     */
    private Optional<? extends DownloadApiModel> downloadApiModel1;


    private Map<String, List<String>> headers;

    @JsonCreator
    public AtsDownloadApplicationDocumentResponse(
            String contentType,
            int statusCode,
            HttpResponse<InputStream> rawResponse,
            Optional<byte[]> body,
            Optional<String> downloadApiModel,
            Optional<? extends DownloadApiModel> downloadApiModel1,
            Map<String, List<String>> headers) {
        Utils.checkNotNull(contentType, "contentType");
        Utils.checkNotNull(statusCode, "statusCode");
        Utils.checkNotNull(rawResponse, "rawResponse");
        Utils.checkNotNull(body, "body");
        Utils.checkNotNull(downloadApiModel, "downloadApiModel");
        Utils.checkNotNull(downloadApiModel1, "downloadApiModel1");
        headers = Utils.emptyMapIfNull(headers);
        Utils.checkNotNull(headers, "headers");
        this.contentType = contentType;
        this.statusCode = statusCode;
        this.rawResponse = rawResponse;
        this.body = body;
        this.downloadApiModel = downloadApiModel;
        this.downloadApiModel1 = downloadApiModel1;
        this.headers = headers;
    }
    
    public AtsDownloadApplicationDocumentResponse(
            String contentType,
            int statusCode,
            HttpResponse<InputStream> rawResponse,
            Map<String, List<String>> headers) {
        this(contentType, statusCode, rawResponse,
            Optional.empty(), Optional.empty(), Optional.empty(),
            headers);
    }

    /**
     * HTTP response content type for this operation
     */
    @JsonIgnore
    public String contentType() {
        return contentType;
    }

    /**
     * HTTP response status code for this operation
     */
    @JsonIgnore
    public int statusCode() {
        return statusCode;
    }

    /**
     * Raw HTTP response; suitable for custom response parsing
     */
    @JsonIgnore
    public HttpResponse<InputStream> rawResponse() {
        return rawResponse;
    }

    @JsonIgnore
    public Optional<byte[]> body() {
        this.body = body
            .or(() -> {
                try {
                    return Optional.of(Utils.extractByteArrayFromBody(rawResponse));
                } catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            });
        return  this.body;
    }

    /**
     * The document related to the application with the given identifiers was retrieved.
     */
    @JsonIgnore
    public Optional<String> downloadApiModel() {
        return downloadApiModel;
    }

    /**
     * The document related to the application with the given identifiers was retrieved.
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public Optional<DownloadApiModel> downloadApiModel1() {
        return (Optional<DownloadApiModel>) downloadApiModel1;
    }

    @JsonIgnore
    public Map<String, List<String>> headers() {
        return headers;
    }

    public static Builder builder() {
        return new Builder();
    }


    /**
     * HTTP response content type for this operation
     */
    public AtsDownloadApplicationDocumentResponse withContentType(String contentType) {
        Utils.checkNotNull(contentType, "contentType");
        this.contentType = contentType;
        return this;
    }

    /**
     * HTTP response status code for this operation
     */
    public AtsDownloadApplicationDocumentResponse withStatusCode(int statusCode) {
        Utils.checkNotNull(statusCode, "statusCode");
        this.statusCode = statusCode;
        return this;
    }

    /**
     * Raw HTTP response; suitable for custom response parsing
     */
    public AtsDownloadApplicationDocumentResponse withRawResponse(HttpResponse<InputStream> rawResponse) {
        Utils.checkNotNull(rawResponse, "rawResponse");
        this.rawResponse = rawResponse;
        return this;
    }

    public AtsDownloadApplicationDocumentResponse withBody(byte[] body) {
        Utils.checkNotNull(body, "body");
        this.body = Optional.ofNullable(body);
        return this;
    }


    public AtsDownloadApplicationDocumentResponse withBody(Optional<byte[]> body) {
        Utils.checkNotNull(body, "body");
        this.body = body;
        return this;
    }

    /**
     * The document related to the application with the given identifiers was retrieved.
     */
    public AtsDownloadApplicationDocumentResponse withDownloadApiModel(String downloadApiModel) {
        Utils.checkNotNull(downloadApiModel, "downloadApiModel");
        this.downloadApiModel = Optional.ofNullable(downloadApiModel);
        return this;
    }


    /**
     * The document related to the application with the given identifiers was retrieved.
     */
    public AtsDownloadApplicationDocumentResponse withDownloadApiModel(Optional<String> downloadApiModel) {
        Utils.checkNotNull(downloadApiModel, "downloadApiModel");
        this.downloadApiModel = downloadApiModel;
        return this;
    }

    /**
     * The document related to the application with the given identifiers was retrieved.
     */
    public AtsDownloadApplicationDocumentResponse withDownloadApiModel1(DownloadApiModel downloadApiModel1) {
        Utils.checkNotNull(downloadApiModel1, "downloadApiModel1");
        this.downloadApiModel1 = Optional.ofNullable(downloadApiModel1);
        return this;
    }


    /**
     * The document related to the application with the given identifiers was retrieved.
     */
    public AtsDownloadApplicationDocumentResponse withDownloadApiModel1(Optional<? extends DownloadApiModel> downloadApiModel1) {
        Utils.checkNotNull(downloadApiModel1, "downloadApiModel1");
        this.downloadApiModel1 = downloadApiModel1;
        return this;
    }

    public AtsDownloadApplicationDocumentResponse withHeaders(Map<String, List<String>> headers) {
        Utils.checkNotNull(headers, "headers");
        this.headers = headers;
        return this;
    }

    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        AtsDownloadApplicationDocumentResponse other = (AtsDownloadApplicationDocumentResponse) o;
        return 
            Utils.enhancedDeepEquals(this.contentType, other.contentType) &&
            Utils.enhancedDeepEquals(this.statusCode, other.statusCode) &&
            Utils.enhancedDeepEquals(this.rawResponse, other.rawResponse) &&
            Utils.enhancedDeepEquals(this.body, other.body) &&
            Utils.enhancedDeepEquals(this.downloadApiModel, other.downloadApiModel) &&
            Utils.enhancedDeepEquals(this.downloadApiModel1, other.downloadApiModel1) &&
            Utils.enhancedDeepEquals(this.headers, other.headers);
    }
    
    @Override
    public int hashCode() {
        return Utils.enhancedHash(
            contentType, statusCode, rawResponse,
            body, downloadApiModel, downloadApiModel1,
            headers);
    }
    
    @Override
    public String toString() {
        return Utils.toString(AtsDownloadApplicationDocumentResponse.class,
                "contentType", contentType,
                "statusCode", statusCode,
                "rawResponse", rawResponse,
                "body", body,
                "downloadApiModel", downloadApiModel,
                "downloadApiModel1", downloadApiModel1,
                "headers", headers);
    }

    @SuppressWarnings("UnusedReturnValue")
    public final static class Builder {

        private String contentType;

        private Integer statusCode;

        private HttpResponse<InputStream> rawResponse;

        private Optional<byte[]> body = Optional.empty();

        private Optional<String> downloadApiModel = Optional.empty();

        private Optional<? extends DownloadApiModel> downloadApiModel1 = Optional.empty();

        private Map<String, List<String>> headers;

        private Builder() {
          // force use of static builder() method
        }


        /**
         * HTTP response content type for this operation
         */
        public Builder contentType(String contentType) {
            Utils.checkNotNull(contentType, "contentType");
            this.contentType = contentType;
            return this;
        }


        /**
         * HTTP response status code for this operation
         */
        public Builder statusCode(int statusCode) {
            Utils.checkNotNull(statusCode, "statusCode");
            this.statusCode = statusCode;
            return this;
        }


        /**
         * Raw HTTP response; suitable for custom response parsing
         */
        public Builder rawResponse(HttpResponse<InputStream> rawResponse) {
            Utils.checkNotNull(rawResponse, "rawResponse");
            this.rawResponse = rawResponse;
            return this;
        }


        public Builder body(byte[] body) {
            Utils.checkNotNull(body, "body");
            this.body = Optional.ofNullable(body);
            return this;
        }

        public Builder body(Optional<byte[]> body) {
            Utils.checkNotNull(body, "body");
            this.body = body;
            return this;
        }


        /**
         * The document related to the application with the given identifiers was retrieved.
         */
        public Builder downloadApiModel(String downloadApiModel) {
            Utils.checkNotNull(downloadApiModel, "downloadApiModel");
            this.downloadApiModel = Optional.ofNullable(downloadApiModel);
            return this;
        }

        /**
         * The document related to the application with the given identifiers was retrieved.
         */
        public Builder downloadApiModel(Optional<String> downloadApiModel) {
            Utils.checkNotNull(downloadApiModel, "downloadApiModel");
            this.downloadApiModel = downloadApiModel;
            return this;
        }


        /**
         * The document related to the application with the given identifiers was retrieved.
         */
        public Builder downloadApiModel1(DownloadApiModel downloadApiModel1) {
            Utils.checkNotNull(downloadApiModel1, "downloadApiModel1");
            this.downloadApiModel1 = Optional.ofNullable(downloadApiModel1);
            return this;
        }

        /**
         * The document related to the application with the given identifiers was retrieved.
         */
        public Builder downloadApiModel1(Optional<? extends DownloadApiModel> downloadApiModel1) {
            Utils.checkNotNull(downloadApiModel1, "downloadApiModel1");
            this.downloadApiModel1 = downloadApiModel1;
            return this;
        }


        public Builder headers(Map<String, List<String>> headers) {
            Utils.checkNotNull(headers, "headers");
            this.headers = headers;
            return this;
        }

        public AtsDownloadApplicationDocumentResponse build() {

            return new AtsDownloadApplicationDocumentResponse(
                contentType, statusCode, rawResponse,
                body, downloadApiModel, downloadApiModel1,
                headers);
        }

    }
}
