/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.operations;

import com.stackone.stackone_client_java.SDKConfiguration;
import com.stackone.stackone_client_java.models.operations.DocumentsListDrivesRequest;
import com.stackone.stackone_client_java.models.operations.DocumentsListDrivesResponse;
import com.stackone.stackone_client_java.operations.DocumentsListDrives;
import com.stackone.stackone_client_java.utils.Exceptions;
import com.stackone.stackone_client_java.utils.Headers;
import com.stackone.stackone_client_java.utils.Options;
import com.stackone.stackone_client_java.utils.RetryConfig;
import com.stackone.stackone_client_java.utils.Utils;
import com.stackone.stackone_client_java.utils.pagination.CursorTracker;
import com.stackone.stackone_client_java.utils.pagination.Paginator;
import java.util.Optional;
import java.util.stream.Stream;

public class DocumentsListDrivesRequestBuilder {
    private DocumentsListDrivesRequest request;
    private Optional<RetryConfig> retryConfig = Optional.empty();
    private final SDKConfiguration sdkConfiguration;
    private final Headers _headers = new Headers();

    public DocumentsListDrivesRequestBuilder(SDKConfiguration sdkConfiguration) {
        this.sdkConfiguration = sdkConfiguration;
    }

    public DocumentsListDrivesRequestBuilder request(DocumentsListDrivesRequest request) {
        Utils.checkNotNull(request, "request");
        this.request = request;
        return this;
    }

    public DocumentsListDrivesRequestBuilder retryConfig(RetryConfig retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = Optional.of(retryConfig);
        return this;
    }

    public DocumentsListDrivesRequestBuilder retryConfig(Optional<RetryConfig> retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = retryConfig;
        return this;
    }

    public DocumentsListDrivesResponse call() {
        Optional<Options> options = Optional.of(Options.builder().retryConfig(this.retryConfig).build());
        DocumentsListDrives.Sync operation = new DocumentsListDrives.Sync(this.sdkConfiguration, options, this._headers);
        return (DocumentsListDrivesResponse)operation.handleResponse(operation.doRequest(this.request));
    }

    public Iterable<DocumentsListDrivesResponse> callAsIterable() {
        Optional<Options> options = Optional.of(Options.builder().retryConfig(this.retryConfig).build());
        DocumentsListDrives.Sync operation = new DocumentsListDrives.Sync(this.sdkConfiguration, options, this._headers);
        Paginator<DocumentsListDrivesRequest, String> iterator = new Paginator<DocumentsListDrivesRequest, String>(this.request, new CursorTracker<String>("$.next", String.class), DocumentsListDrivesRequest::withNext, nextRequest -> Exceptions.unchecked(() -> operation.doRequest(this.request)).get());
        return () -> Utils.transform(iterator, operation::handleResponse);
    }

    public Stream<DocumentsListDrivesResponse> callAsStream() {
        return Utils.toStream(this.callAsIterable());
    }
}

