/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.stackone.stackone_client_java.utils.Utils;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import org.openapitools.jackson.nullable.JsonNullable;

/**
 * AccountAddressCountry
 * 
 * <p>The country code
 */
public class AccountAddressCountry {
    /**
     * The ISO 3166-1 alpha-2 code of the country.
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("value")
    private JsonNullable<? extends AccountAddressValue> value;

    /**
     * The source value of the ISO 3166-1 alpha-2 code of the country.
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("source_value")
    private JsonNullable<? extends AccountAddressSourceValue> sourceValue;

    @JsonCreator
    public AccountAddressCountry(
            @JsonProperty("value") JsonNullable<? extends AccountAddressValue> value,
            @JsonProperty("source_value") JsonNullable<? extends AccountAddressSourceValue> sourceValue) {
        Utils.checkNotNull(value, "value");
        Utils.checkNotNull(sourceValue, "sourceValue");
        this.value = value;
        this.sourceValue = sourceValue;
    }
    
    public AccountAddressCountry() {
        this(JsonNullable.undefined(), JsonNullable.undefined());
    }

    /**
     * The ISO 3166-1 alpha-2 code of the country.
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<AccountAddressValue> value() {
        return (JsonNullable<AccountAddressValue>) value;
    }

    /**
     * The source value of the ISO 3166-1 alpha-2 code of the country.
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<AccountAddressSourceValue> sourceValue() {
        return (JsonNullable<AccountAddressSourceValue>) sourceValue;
    }

    public static Builder builder() {
        return new Builder();
    }


    /**
     * The ISO 3166-1 alpha-2 code of the country.
     */
    public AccountAddressCountry withValue(AccountAddressValue value) {
        Utils.checkNotNull(value, "value");
        this.value = JsonNullable.of(value);
        return this;
    }

    /**
     * The ISO 3166-1 alpha-2 code of the country.
     */
    public AccountAddressCountry withValue(JsonNullable<? extends AccountAddressValue> value) {
        Utils.checkNotNull(value, "value");
        this.value = value;
        return this;
    }

    /**
     * The source value of the ISO 3166-1 alpha-2 code of the country.
     */
    public AccountAddressCountry withSourceValue(AccountAddressSourceValue sourceValue) {
        Utils.checkNotNull(sourceValue, "sourceValue");
        this.sourceValue = JsonNullable.of(sourceValue);
        return this;
    }

    /**
     * The source value of the ISO 3166-1 alpha-2 code of the country.
     */
    public AccountAddressCountry withSourceValue(JsonNullable<? extends AccountAddressSourceValue> sourceValue) {
        Utils.checkNotNull(sourceValue, "sourceValue");
        this.sourceValue = sourceValue;
        return this;
    }

    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        AccountAddressCountry other = (AccountAddressCountry) o;
        return 
            Utils.enhancedDeepEquals(this.value, other.value) &&
            Utils.enhancedDeepEquals(this.sourceValue, other.sourceValue);
    }
    
    @Override
    public int hashCode() {
        return Utils.enhancedHash(
            value, sourceValue);
    }
    
    @Override
    public String toString() {
        return Utils.toString(AccountAddressCountry.class,
                "value", value,
                "sourceValue", sourceValue);
    }

    @SuppressWarnings("UnusedReturnValue")
    public final static class Builder {

        private JsonNullable<? extends AccountAddressValue> value = JsonNullable.undefined();

        private JsonNullable<? extends AccountAddressSourceValue> sourceValue = JsonNullable.undefined();

        private Builder() {
          // force use of static builder() method
        }


        /**
         * The ISO 3166-1 alpha-2 code of the country.
         */
        public Builder value(AccountAddressValue value) {
            Utils.checkNotNull(value, "value");
            this.value = JsonNullable.of(value);
            return this;
        }

        /**
         * The ISO 3166-1 alpha-2 code of the country.
         */
        public Builder value(JsonNullable<? extends AccountAddressValue> value) {
            Utils.checkNotNull(value, "value");
            this.value = value;
            return this;
        }


        /**
         * The source value of the ISO 3166-1 alpha-2 code of the country.
         */
        public Builder sourceValue(AccountAddressSourceValue sourceValue) {
            Utils.checkNotNull(sourceValue, "sourceValue");
            this.sourceValue = JsonNullable.of(sourceValue);
            return this;
        }

        /**
         * The source value of the ISO 3166-1 alpha-2 code of the country.
         */
        public Builder sourceValue(JsonNullable<? extends AccountAddressSourceValue> sourceValue) {
            Utils.checkNotNull(sourceValue, "sourceValue");
            this.sourceValue = sourceValue;
            return this;
        }

        public AccountAddressCountry build() {

            return new AccountAddressCountry(
                value, sourceValue);
        }

    }
}
