/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java.models.operations.async;

import static com.stackone.stackone_client_java.operations.Operations.AsyncRequestOperation;
import static com.stackone.stackone_client_java.utils.reactive.ReactiveUtils.mapAsync;

import com.stackone.stackone_client_java.SDKConfiguration;
import com.stackone.stackone_client_java.models.operations.AtsListJobCustomFieldDefinitionsRequest;
import com.stackone.stackone_client_java.operations.AtsListJobCustomFieldDefinitions;
import com.stackone.stackone_client_java.utils.Blob;
import com.stackone.stackone_client_java.utils.Headers;
import com.stackone.stackone_client_java.utils.Options;
import com.stackone.stackone_client_java.utils.RetryConfig;
import com.stackone.stackone_client_java.utils.Utils;
import com.stackone.stackone_client_java.utils.pagination.AsyncPaginator;
import com.stackone.stackone_client_java.utils.pagination.CursorTracker;
import java.lang.String;
import java.net.http.HttpResponse;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Flow;
import org.reactivestreams.FlowAdapters;
import org.reactivestreams.Publisher;

public class AtsListJobCustomFieldDefinitionsRequestBuilder {

    private AtsListJobCustomFieldDefinitionsRequest request;
    private Optional<RetryConfig> retryConfig = Optional.empty();
    private final SDKConfiguration sdkConfiguration;
    private final Headers _headers = new Headers(); 

    public AtsListJobCustomFieldDefinitionsRequestBuilder(SDKConfiguration sdkConfiguration) {
        this.sdkConfiguration = sdkConfiguration;
    }

    public AtsListJobCustomFieldDefinitionsRequestBuilder request(AtsListJobCustomFieldDefinitionsRequest request) {
        Utils.checkNotNull(request, "request");
        this.request = request;
        return this;
    }
                
    public AtsListJobCustomFieldDefinitionsRequestBuilder retryConfig(RetryConfig retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = Optional.of(retryConfig);
        return this;
    }

    public AtsListJobCustomFieldDefinitionsRequestBuilder retryConfig(Optional<RetryConfig> retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = retryConfig;
        return this;
    }

    public CompletableFuture<AtsListJobCustomFieldDefinitionsResponse> call() {
        Optional<Options> options = Optional.of(Options.builder()
            .retryConfig(retryConfig)
            .build());

        AsyncRequestOperation<AtsListJobCustomFieldDefinitionsRequest, AtsListJobCustomFieldDefinitionsResponse> operation
              = new AtsListJobCustomFieldDefinitions.Async(
                                    sdkConfiguration, options, sdkConfiguration.retryScheduler(),
                                    _headers);

        return operation.doRequest(request)
            .thenCompose(operation::handleResponse);
    }

    /**
     * Returns a Publisher that performs next page calls till no more pages
     * are returned.
     *
     * <p>The returned publisher can be used with reactive frameworks:
     * <pre><code>
     * Publisher&lt;AtsListJobCustomFieldDefinitionsResponse&gt; publisher = builder.callAsPublisher();
     * publisher.subscribe(new Subscriber&lt;AtsListJobCustomFieldDefinitionsResponse&gt;() {
     *     // Handle onNext, onError, onComplete
     * });
     * </code></pre>
     *
     * @return A Publisher that emits pages asynchronously
     */
    public Publisher<AtsListJobCustomFieldDefinitionsResponse> callAsPublisher() {
        AtsListJobCustomFieldDefinitionsRequest request = this.request;
        Optional<Options> options = Optional.of(Options.builder()
            .retryConfig(retryConfig)
            .build());

        AsyncRequestOperation<AtsListJobCustomFieldDefinitionsRequest, AtsListJobCustomFieldDefinitionsResponse> operation
              = new AtsListJobCustomFieldDefinitions.Async(
                                    sdkConfiguration, options, sdkConfiguration.retryScheduler(),
                                    _headers);

        Flow.Publisher<HttpResponse<Blob>> asyncPaginator = new AsyncPaginator<>(
            request,
            new CursorTracker<>("$.next", String.class),
                    AtsListJobCustomFieldDefinitionsRequest::withNext,
            operation::doRequest);

        Flow.Publisher<AtsListJobCustomFieldDefinitionsResponse> flowPublisher = mapAsync(asyncPaginator, operation::handleResponse);

        // Convert Flow.Publisher to Reactive Streams Publisher at the last stage
        return FlowAdapters.toPublisher(flowPublisher);
    }

}
