/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java.models.operations;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.stackone.stackone_client_java.models.components.JsonRpcMessageDto;
import com.stackone.stackone_client_java.utils.SpeakeasyMetadata;
import com.stackone.stackone_client_java.utils.Utils;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Optional;


public class StackoneMcpPostRequest {
    /**
     * Account secure id for the target provider account (optional if x-account-id query parameter is
     * provided)
     */
    @SpeakeasyMetadata("header:style=simple,explode=false,name=x-account-id")
    private Optional<String> xAccountId;

    /**
     * Account secure id (alternative to x-account-id header)
     */
    @SpeakeasyMetadata("queryParam:style=form,explode=true,name=x-account-id")
    private Optional<? extends Object> xAccountIdQueryParameter;

    /**
     * Session id; omit for initialize, include for subsequent calls
     */
    @SpeakeasyMetadata("header:style=simple,explode=false,name=mcp-session-id")
    private Optional<String> mcpSessionId;

    /**
     * JSON-RPC 2.0 message
     */
    @SpeakeasyMetadata("request:mediaType=application/json")
    private JsonRpcMessageDto jsonRpcMessageDto;

    @JsonCreator
    public StackoneMcpPostRequest(
            Optional<String> xAccountId,
            Optional<? extends Object> xAccountIdQueryParameter,
            Optional<String> mcpSessionId,
            JsonRpcMessageDto jsonRpcMessageDto) {
        Utils.checkNotNull(xAccountId, "xAccountId");
        Utils.checkNotNull(xAccountIdQueryParameter, "xAccountIdQueryParameter");
        Utils.checkNotNull(mcpSessionId, "mcpSessionId");
        Utils.checkNotNull(jsonRpcMessageDto, "jsonRpcMessageDto");
        this.xAccountId = xAccountId;
        this.xAccountIdQueryParameter = xAccountIdQueryParameter;
        this.mcpSessionId = mcpSessionId;
        this.jsonRpcMessageDto = jsonRpcMessageDto;
    }
    
    public StackoneMcpPostRequest(
            JsonRpcMessageDto jsonRpcMessageDto) {
        this(Optional.empty(), Optional.empty(), Optional.empty(),
            jsonRpcMessageDto);
    }

    /**
     * Account secure id for the target provider account (optional if x-account-id query parameter is
     * provided)
     */
    @JsonIgnore
    public Optional<String> xAccountId() {
        return xAccountId;
    }

    /**
     * Account secure id (alternative to x-account-id header)
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public Optional<Object> xAccountIdQueryParameter() {
        return (Optional<Object>) xAccountIdQueryParameter;
    }

    /**
     * Session id; omit for initialize, include for subsequent calls
     */
    @JsonIgnore
    public Optional<String> mcpSessionId() {
        return mcpSessionId;
    }

    /**
     * JSON-RPC 2.0 message
     */
    @JsonIgnore
    public JsonRpcMessageDto jsonRpcMessageDto() {
        return jsonRpcMessageDto;
    }

    public static Builder builder() {
        return new Builder();
    }


    /**
     * Account secure id for the target provider account (optional if x-account-id query parameter is
     * provided)
     */
    public StackoneMcpPostRequest withXAccountId(String xAccountId) {
        Utils.checkNotNull(xAccountId, "xAccountId");
        this.xAccountId = Optional.ofNullable(xAccountId);
        return this;
    }


    /**
     * Account secure id for the target provider account (optional if x-account-id query parameter is
     * provided)
     */
    public StackoneMcpPostRequest withXAccountId(Optional<String> xAccountId) {
        Utils.checkNotNull(xAccountId, "xAccountId");
        this.xAccountId = xAccountId;
        return this;
    }

    /**
     * Account secure id (alternative to x-account-id header)
     */
    public StackoneMcpPostRequest withXAccountIdQueryParameter(Object xAccountIdQueryParameter) {
        Utils.checkNotNull(xAccountIdQueryParameter, "xAccountIdQueryParameter");
        this.xAccountIdQueryParameter = Optional.ofNullable(xAccountIdQueryParameter);
        return this;
    }


    /**
     * Account secure id (alternative to x-account-id header)
     */
    public StackoneMcpPostRequest withXAccountIdQueryParameter(Optional<? extends Object> xAccountIdQueryParameter) {
        Utils.checkNotNull(xAccountIdQueryParameter, "xAccountIdQueryParameter");
        this.xAccountIdQueryParameter = xAccountIdQueryParameter;
        return this;
    }

    /**
     * Session id; omit for initialize, include for subsequent calls
     */
    public StackoneMcpPostRequest withMcpSessionId(String mcpSessionId) {
        Utils.checkNotNull(mcpSessionId, "mcpSessionId");
        this.mcpSessionId = Optional.ofNullable(mcpSessionId);
        return this;
    }


    /**
     * Session id; omit for initialize, include for subsequent calls
     */
    public StackoneMcpPostRequest withMcpSessionId(Optional<String> mcpSessionId) {
        Utils.checkNotNull(mcpSessionId, "mcpSessionId");
        this.mcpSessionId = mcpSessionId;
        return this;
    }

    /**
     * JSON-RPC 2.0 message
     */
    public StackoneMcpPostRequest withJsonRpcMessageDto(JsonRpcMessageDto jsonRpcMessageDto) {
        Utils.checkNotNull(jsonRpcMessageDto, "jsonRpcMessageDto");
        this.jsonRpcMessageDto = jsonRpcMessageDto;
        return this;
    }

    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        StackoneMcpPostRequest other = (StackoneMcpPostRequest) o;
        return 
            Utils.enhancedDeepEquals(this.xAccountId, other.xAccountId) &&
            Utils.enhancedDeepEquals(this.xAccountIdQueryParameter, other.xAccountIdQueryParameter) &&
            Utils.enhancedDeepEquals(this.mcpSessionId, other.mcpSessionId) &&
            Utils.enhancedDeepEquals(this.jsonRpcMessageDto, other.jsonRpcMessageDto);
    }
    
    @Override
    public int hashCode() {
        return Utils.enhancedHash(
            xAccountId, xAccountIdQueryParameter, mcpSessionId,
            jsonRpcMessageDto);
    }
    
    @Override
    public String toString() {
        return Utils.toString(StackoneMcpPostRequest.class,
                "xAccountId", xAccountId,
                "xAccountIdQueryParameter", xAccountIdQueryParameter,
                "mcpSessionId", mcpSessionId,
                "jsonRpcMessageDto", jsonRpcMessageDto);
    }

    @SuppressWarnings("UnusedReturnValue")
    public final static class Builder {

        private Optional<String> xAccountId = Optional.empty();

        private Optional<? extends Object> xAccountIdQueryParameter = Optional.empty();

        private Optional<String> mcpSessionId = Optional.empty();

        private JsonRpcMessageDto jsonRpcMessageDto;

        private Builder() {
          // force use of static builder() method
        }


        /**
         * Account secure id for the target provider account (optional if x-account-id query parameter is
         * provided)
         */
        public Builder xAccountId(String xAccountId) {
            Utils.checkNotNull(xAccountId, "xAccountId");
            this.xAccountId = Optional.ofNullable(xAccountId);
            return this;
        }

        /**
         * Account secure id for the target provider account (optional if x-account-id query parameter is
         * provided)
         */
        public Builder xAccountId(Optional<String> xAccountId) {
            Utils.checkNotNull(xAccountId, "xAccountId");
            this.xAccountId = xAccountId;
            return this;
        }


        /**
         * Account secure id (alternative to x-account-id header)
         */
        public Builder xAccountIdQueryParameter(Object xAccountIdQueryParameter) {
            Utils.checkNotNull(xAccountIdQueryParameter, "xAccountIdQueryParameter");
            this.xAccountIdQueryParameter = Optional.ofNullable(xAccountIdQueryParameter);
            return this;
        }

        /**
         * Account secure id (alternative to x-account-id header)
         */
        public Builder xAccountIdQueryParameter(Optional<? extends Object> xAccountIdQueryParameter) {
            Utils.checkNotNull(xAccountIdQueryParameter, "xAccountIdQueryParameter");
            this.xAccountIdQueryParameter = xAccountIdQueryParameter;
            return this;
        }


        /**
         * Session id; omit for initialize, include for subsequent calls
         */
        public Builder mcpSessionId(String mcpSessionId) {
            Utils.checkNotNull(mcpSessionId, "mcpSessionId");
            this.mcpSessionId = Optional.ofNullable(mcpSessionId);
            return this;
        }

        /**
         * Session id; omit for initialize, include for subsequent calls
         */
        public Builder mcpSessionId(Optional<String> mcpSessionId) {
            Utils.checkNotNull(mcpSessionId, "mcpSessionId");
            this.mcpSessionId = mcpSessionId;
            return this;
        }


        /**
         * JSON-RPC 2.0 message
         */
        public Builder jsonRpcMessageDto(JsonRpcMessageDto jsonRpcMessageDto) {
            Utils.checkNotNull(jsonRpcMessageDto, "jsonRpcMessageDto");
            this.jsonRpcMessageDto = jsonRpcMessageDto;
            return this;
        }

        public StackoneMcpPostRequest build() {

            return new StackoneMcpPostRequest(
                xAccountId, xAccountIdQueryParameter, mcpSessionId,
                jsonRpcMessageDto);
        }

    }
}
