/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java.models.operations.async;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.stackone.stackone_client_java.models.components.ProxyResponseApiModel;
import com.stackone.stackone_client_java.utils.AsyncResponse;
import com.stackone.stackone_client_java.utils.Blob;
import com.stackone.stackone_client_java.utils.Utils;
import java.lang.Integer;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.net.http.HttpResponse;
import java.util.List;
import java.util.Map;
import java.util.Optional;


public class StackoneProxyRequestResponse implements AsyncResponse {
    /**
     * HTTP response content type for this operation
     */
    private String contentType;

    /**
     * HTTP response status code for this operation
     */
    private int statusCode;

    /**
     * Raw HTTP response; suitable for custom response parsing
     */
    private HttpResponse<Blob> rawResponse;

    /**
     * The proxy request was successful.
     */
    private Optional<? extends ProxyResponseApiModel> proxyResponseApiModel;


    private Map<String, List<String>> headers;

    @JsonCreator
    public StackoneProxyRequestResponse(
            String contentType,
            int statusCode,
            HttpResponse<Blob> rawResponse,
            Optional<? extends ProxyResponseApiModel> proxyResponseApiModel,
            Map<String, List<String>> headers) {
        Utils.checkNotNull(contentType, "contentType");
        Utils.checkNotNull(statusCode, "statusCode");
        Utils.checkNotNull(rawResponse, "rawResponse");
        Utils.checkNotNull(proxyResponseApiModel, "proxyResponseApiModel");
        headers = Utils.emptyMapIfNull(headers);
        Utils.checkNotNull(headers, "headers");
        this.contentType = contentType;
        this.statusCode = statusCode;
        this.rawResponse = rawResponse;
        this.proxyResponseApiModel = proxyResponseApiModel;
        this.headers = headers;
    }
    
    public StackoneProxyRequestResponse(
            String contentType,
            int statusCode,
            HttpResponse<Blob> rawResponse,
            Map<String, List<String>> headers) {
        this(contentType, statusCode, rawResponse,
            Optional.empty(), headers);
    }

    /**
     * HTTP response content type for this operation
     */
    @JsonIgnore
    public String contentType() {
        return contentType;
    }

    /**
     * HTTP response status code for this operation
     */
    @JsonIgnore
    public int statusCode() {
        return statusCode;
    }

    /**
     * Raw HTTP response; suitable for custom response parsing
     */
    @JsonIgnore
    public HttpResponse<Blob> rawResponse() {
        return rawResponse;
    }

    /**
     * The proxy request was successful.
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public Optional<ProxyResponseApiModel> proxyResponseApiModel() {
        return (Optional<ProxyResponseApiModel>) proxyResponseApiModel;
    }

    @JsonIgnore
    public Map<String, List<String>> headers() {
        return headers;
    }

    public static Builder builder() {
        return new Builder();
    }


    /**
     * HTTP response content type for this operation
     */
    public StackoneProxyRequestResponse withContentType(String contentType) {
        Utils.checkNotNull(contentType, "contentType");
        this.contentType = contentType;
        return this;
    }

    /**
     * HTTP response status code for this operation
     */
    public StackoneProxyRequestResponse withStatusCode(int statusCode) {
        Utils.checkNotNull(statusCode, "statusCode");
        this.statusCode = statusCode;
        return this;
    }

    /**
     * Raw HTTP response; suitable for custom response parsing
     */
    public StackoneProxyRequestResponse withRawResponse(HttpResponse<Blob> rawResponse) {
        Utils.checkNotNull(rawResponse, "rawResponse");
        this.rawResponse = rawResponse;
        return this;
    }

    /**
     * The proxy request was successful.
     */
    public StackoneProxyRequestResponse withProxyResponseApiModel(ProxyResponseApiModel proxyResponseApiModel) {
        Utils.checkNotNull(proxyResponseApiModel, "proxyResponseApiModel");
        this.proxyResponseApiModel = Optional.ofNullable(proxyResponseApiModel);
        return this;
    }


    /**
     * The proxy request was successful.
     */
    public StackoneProxyRequestResponse withProxyResponseApiModel(Optional<? extends ProxyResponseApiModel> proxyResponseApiModel) {
        Utils.checkNotNull(proxyResponseApiModel, "proxyResponseApiModel");
        this.proxyResponseApiModel = proxyResponseApiModel;
        return this;
    }

    public StackoneProxyRequestResponse withHeaders(Map<String, List<String>> headers) {
        Utils.checkNotNull(headers, "headers");
        this.headers = headers;
        return this;
    }

    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        StackoneProxyRequestResponse other = (StackoneProxyRequestResponse) o;
        return 
            Utils.enhancedDeepEquals(this.contentType, other.contentType) &&
            Utils.enhancedDeepEquals(this.statusCode, other.statusCode) &&
            Utils.enhancedDeepEquals(this.rawResponse, other.rawResponse) &&
            Utils.enhancedDeepEquals(this.proxyResponseApiModel, other.proxyResponseApiModel) &&
            Utils.enhancedDeepEquals(this.headers, other.headers);
    }
    
    @Override
    public int hashCode() {
        return Utils.enhancedHash(
            contentType, statusCode, rawResponse,
            proxyResponseApiModel, headers);
    }
    
    @Override
    public String toString() {
        return Utils.toString(StackoneProxyRequestResponse.class,
                "contentType", contentType,
                "statusCode", statusCode,
                "rawResponse", rawResponse,
                "proxyResponseApiModel", proxyResponseApiModel,
                "headers", headers);
    }

    @SuppressWarnings("UnusedReturnValue")
    public final static class Builder {

        private String contentType;

        private Integer statusCode;

        private HttpResponse<Blob> rawResponse;

        private Optional<? extends ProxyResponseApiModel> proxyResponseApiModel = Optional.empty();

        private Map<String, List<String>> headers;

        private Builder() {
          // force use of static builder() method
        }


        /**
         * HTTP response content type for this operation
         */
        public Builder contentType(String contentType) {
            Utils.checkNotNull(contentType, "contentType");
            this.contentType = contentType;
            return this;
        }


        /**
         * HTTP response status code for this operation
         */
        public Builder statusCode(int statusCode) {
            Utils.checkNotNull(statusCode, "statusCode");
            this.statusCode = statusCode;
            return this;
        }


        /**
         * Raw HTTP response; suitable for custom response parsing
         */
        public Builder rawResponse(HttpResponse<Blob> rawResponse) {
            Utils.checkNotNull(rawResponse, "rawResponse");
            this.rawResponse = rawResponse;
            return this;
        }


        /**
         * The proxy request was successful.
         */
        public Builder proxyResponseApiModel(ProxyResponseApiModel proxyResponseApiModel) {
            Utils.checkNotNull(proxyResponseApiModel, "proxyResponseApiModel");
            this.proxyResponseApiModel = Optional.ofNullable(proxyResponseApiModel);
            return this;
        }

        /**
         * The proxy request was successful.
         */
        public Builder proxyResponseApiModel(Optional<? extends ProxyResponseApiModel> proxyResponseApiModel) {
            Utils.checkNotNull(proxyResponseApiModel, "proxyResponseApiModel");
            this.proxyResponseApiModel = proxyResponseApiModel;
            return this;
        }


        public Builder headers(Map<String, List<String>> headers) {
            Utils.checkNotNull(headers, "headers");
            this.headers = headers;
            return this;
        }

        public StackoneProxyRequestResponse build() {

            return new StackoneProxyRequestResponse(
                contentType, statusCode, rawResponse,
                proxyResponseApiModel, headers);
        }

    }
}
