/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.operations;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.stackone.stackone_client_java.models.components.AccountingAccountResult;
import com.stackone.stackone_client_java.utils.Response;
import com.stackone.stackone_client_java.utils.Utils;
import java.io.InputStream;
import java.net.http.HttpResponse;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class AccountingGetCompanyAccountResponse
implements Response {
    private String contentType;
    private int statusCode;
    private HttpResponse<InputStream> rawResponse;
    private Optional<? extends AccountingAccountResult> accountingAccountResult;
    private Map<String, List<String>> headers;

    @JsonCreator
    public AccountingGetCompanyAccountResponse(String contentType, int statusCode, HttpResponse<InputStream> rawResponse, Optional<? extends AccountingAccountResult> accountingAccountResult, Map<String, List<String>> headers) {
        Utils.checkNotNull(contentType, "contentType");
        Utils.checkNotNull(statusCode, "statusCode");
        Utils.checkNotNull(rawResponse, "rawResponse");
        Utils.checkNotNull(accountingAccountResult, "accountingAccountResult");
        headers = Utils.emptyMapIfNull(headers);
        Utils.checkNotNull(headers, "headers");
        this.contentType = contentType;
        this.statusCode = statusCode;
        this.rawResponse = rawResponse;
        this.accountingAccountResult = accountingAccountResult;
        this.headers = headers;
    }

    public AccountingGetCompanyAccountResponse(String contentType, int statusCode, HttpResponse<InputStream> rawResponse, Map<String, List<String>> headers) {
        this(contentType, statusCode, rawResponse, Optional.empty(), headers);
    }

    @Override
    @JsonIgnore
    public String contentType() {
        return this.contentType;
    }

    @Override
    @JsonIgnore
    public int statusCode() {
        return this.statusCode;
    }

    @Override
    @JsonIgnore
    public HttpResponse<InputStream> rawResponse() {
        return this.rawResponse;
    }

    @JsonIgnore
    public Optional<AccountingAccountResult> accountingAccountResult() {
        return this.accountingAccountResult;
    }

    @JsonIgnore
    public Map<String, List<String>> headers() {
        return this.headers;
    }

    public static Builder builder() {
        return new Builder();
    }

    public AccountingGetCompanyAccountResponse withContentType(String contentType) {
        Utils.checkNotNull(contentType, "contentType");
        this.contentType = contentType;
        return this;
    }

    public AccountingGetCompanyAccountResponse withStatusCode(int statusCode) {
        Utils.checkNotNull(statusCode, "statusCode");
        this.statusCode = statusCode;
        return this;
    }

    public AccountingGetCompanyAccountResponse withRawResponse(HttpResponse<InputStream> rawResponse) {
        Utils.checkNotNull(rawResponse, "rawResponse");
        this.rawResponse = rawResponse;
        return this;
    }

    public AccountingGetCompanyAccountResponse withAccountingAccountResult(AccountingAccountResult accountingAccountResult) {
        Utils.checkNotNull(accountingAccountResult, "accountingAccountResult");
        this.accountingAccountResult = Optional.ofNullable(accountingAccountResult);
        return this;
    }

    public AccountingGetCompanyAccountResponse withAccountingAccountResult(Optional<? extends AccountingAccountResult> accountingAccountResult) {
        Utils.checkNotNull(accountingAccountResult, "accountingAccountResult");
        this.accountingAccountResult = accountingAccountResult;
        return this;
    }

    public AccountingGetCompanyAccountResponse withHeaders(Map<String, List<String>> headers) {
        Utils.checkNotNull(headers, "headers");
        this.headers = headers;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AccountingGetCompanyAccountResponse other = (AccountingGetCompanyAccountResponse)o;
        return Utils.enhancedDeepEquals(this.contentType, other.contentType) && Utils.enhancedDeepEquals(this.statusCode, other.statusCode) && Utils.enhancedDeepEquals(this.rawResponse, other.rawResponse) && Utils.enhancedDeepEquals(this.accountingAccountResult, other.accountingAccountResult) && Utils.enhancedDeepEquals(this.headers, other.headers);
    }

    public int hashCode() {
        return Utils.enhancedHash(this.contentType, this.statusCode, this.rawResponse, this.accountingAccountResult, this.headers);
    }

    public String toString() {
        return Utils.toString(AccountingGetCompanyAccountResponse.class, "contentType", this.contentType, "statusCode", this.statusCode, "rawResponse", this.rawResponse, "accountingAccountResult", this.accountingAccountResult, "headers", this.headers);
    }

    public static final class Builder {
        private String contentType;
        private Integer statusCode;
        private HttpResponse<InputStream> rawResponse;
        private Optional<? extends AccountingAccountResult> accountingAccountResult = Optional.empty();
        private Map<String, List<String>> headers;

        private Builder() {
        }

        public Builder contentType(String contentType) {
            Utils.checkNotNull(contentType, "contentType");
            this.contentType = contentType;
            return this;
        }

        public Builder statusCode(int statusCode) {
            Utils.checkNotNull(statusCode, "statusCode");
            this.statusCode = statusCode;
            return this;
        }

        public Builder rawResponse(HttpResponse<InputStream> rawResponse) {
            Utils.checkNotNull(rawResponse, "rawResponse");
            this.rawResponse = rawResponse;
            return this;
        }

        public Builder accountingAccountResult(AccountingAccountResult accountingAccountResult) {
            Utils.checkNotNull(accountingAccountResult, "accountingAccountResult");
            this.accountingAccountResult = Optional.ofNullable(accountingAccountResult);
            return this;
        }

        public Builder accountingAccountResult(Optional<? extends AccountingAccountResult> accountingAccountResult) {
            Utils.checkNotNull(accountingAccountResult, "accountingAccountResult");
            this.accountingAccountResult = accountingAccountResult;
            return this;
        }

        public Builder headers(Map<String, List<String>> headers) {
            Utils.checkNotNull(headers, "headers");
            this.headers = headers;
            return this;
        }

        public AccountingGetCompanyAccountResponse build() {
            return new AccountingGetCompanyAccountResponse(this.contentType, this.statusCode, this.rawResponse, this.accountingAccountResult, this.headers);
        }
    }
}

